/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.GroupNode;
import com.google.security.zynamics.binnavi.API.disassembly.IGraphNode;
import com.google.security.zynamics.binnavi.API.disassembly.IViewNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.Tag;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewEdge;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class ViewNode
implements ApiObject<INaviViewNode>,
IGraphNode<ViewNode> {
    private final View m_view;
    private final INaviViewNode m_node;
    private final TagManager m_tagManager;
    private final ListenerProvider<IViewNodeListener> m_listeners = new ListenerProvider();

    protected ViewNode(View view, INaviViewNode node, TagManager manager) {
        this.m_view = Preconditions.checkNotNull(view, "Error: View argument can not be null");
        this.m_node = Preconditions.checkNotNull(node, "Error: Node argument can't be null");
        this.m_tagManager = Preconditions.checkNotNull(manager, "Error: Manager argument can not be null");
    }

    private List<Tag> getTags(Collection<CTag> tags) {
        ArrayList<Tag> apiTags = new ArrayList<Tag>();
        for (CTag tag : tags) {
            apiTags.add(this.m_tagManager.getTag(tag));
        }
        return apiTags;
    }

    protected List<ViewNode> convert(List<? extends INaviViewNode> nodes) {
        ArrayList<ViewNode> out = new ArrayList<ViewNode>();
        for (INaviViewNode iNaviViewNode : nodes) {
            out.add(ObjectFinders.getObject(iNaviViewNode, this.getView().getGraph().getNodes()));
        }
        return out;
    }

    protected ListenerProvider<IViewNodeListener> getListeners() {
        return this.m_listeners;
    }

    protected abstract String getName();

    protected View getView() {
        return this.m_view;
    }

    @Override
    public INaviViewNode getNative() {
        return this.m_node;
    }

    public void addListener(IViewNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addTag(Tag tag) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tag, "Error: Tag argument can't be null");
        try {
            this.m_node.tagNode((CTag)tag.getNative().getObject());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public Color getBorderColor() {
        return this.m_node.getBorderColor();
    }

    @Override
    public List<ViewNode> getChildren() {
        return this.convert(this.m_node.getChildren());
    }

    public Color getColor() {
        return this.m_node.getColor();
    }

    public List<ViewEdge> getIncomingEdges() {
        ArrayList<ViewEdge> edges = new ArrayList<ViewEdge>();
        for (ViewEdge edge : this.m_view.getGraph().getEdges()) {
            if (edge.getTarget() != this) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List<ViewEdge> getOutgoingEdges() {
        ArrayList<ViewEdge> edges = new ArrayList<ViewEdge>();
        for (ViewEdge edge : this.m_view.getGraph().getEdges()) {
            if (edge.getSource() != this) continue;
            edges.add(edge);
        }
        return edges;
    }

    public GroupNode getParentGroup() {
        INaviGroupNode parentGroup = this.m_node.getParentGroup();
        return parentGroup == null ? null : (GroupNode)ObjectFinders.getObject(this.m_node.getParentGroup(), this.m_view.getGraph().getNodes());
    }

    @Override
    public List<ViewNode> getParents() {
        return this.convert(this.m_node.getParents());
    }

    public List<Tag> getTags() {
        return this.getTags(this.m_node.getTags());
    }

    public double getX() {
        return this.m_node.getX();
    }

    public double getY() {
        return this.m_node.getY();
    }

    public boolean isSelected() {
        return this.m_node.isSelected();
    }

    public boolean isTagged(Tag tag) {
        Preconditions.checkNotNull(tag, "Error: Tag argument can not be null");
        return this.m_node.isTagged((CTag)tag.getNative().getObject());
    }

    public boolean isVisible() {
        return this.m_node.isVisible();
    }

    public void removeListener(IViewNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void removeTag(Tag tag) throws CouldntSaveDataException {
        Preconditions.checkNotNull(tag, "Error: Tag argument can't be null");
        try {
            this.m_node.removeTag((CTag)tag.getNative().getObject());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setBorderColor(Color color) {
        this.m_node.setBorderColor(color);
    }

    public void setColor(Color color) {
        this.m_node.setColor(color);
    }

    public void setSelected(boolean selection) {
        this.m_node.setSelected(selection);
    }

    public void setX(double newX) {
        this.m_node.setX(newX);
    }

    public void setY(double newY) {
        this.m_node.setY(newY);
    }

    public String toString() {
        return this.getName();
    }
}

