/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ITraceListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.TraceEvent;
import com.google.security.zynamics.binnavi.API.disassembly.TraceEventType;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListListener;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class Trace
implements ApiObject<TraceList> {
    private final TraceList trace;
    private final List<TraceEvent> events = new ArrayList<TraceEvent>();
    private final InternalTraceListener listener = new InternalTraceListener();
    private final ListenerProvider<ITraceListener> listeners = new ListenerProvider();

    public Trace(TraceList trace2) {
        this.trace = trace2;
        for (ITraceEvent event : this.trace) {
            this.events.add(new TraceEvent(event));
        }
        this.trace.addListener(this.listener);
    }

    @Override
    public TraceList getNative() {
        return this.trace;
    }

    public void addEvent(int tid, Module module, Address address, TraceEventType type) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        this.trace.addEvent(new com.google.security.zynamics.binnavi.debug.models.trace.TraceEvent(tid, new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))), type.getNative(), new ArrayList<TraceRegister>()));
    }

    public void addListener(ITraceListener listener) {
        this.listeners.addListener(listener);
    }

    public String getDescription() {
        return this.trace.getDescription();
    }

    public List<TraceEvent> getEvents() {
        return new ArrayList<TraceEvent>(this.events);
    }

    public String getName() {
        return this.trace.getName();
    }

    public void removeListener(ITraceListener listener) {
        this.listeners.removeListener(listener);
    }

    public void save() throws CouldntSaveDataException {
        try {
            this.trace.save();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.trace.setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.trace.setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        return String.format("Trace '%s' [%d events]", this.getName(), this.trace.getEventCount());
    }

    private class InternalTraceListener
    implements ITraceListListener {
        private InternalTraceListener() {
        }

        @Override
        public void changedDescription(TraceList traceList) {
            for (ITraceListener listener : Trace.this.listeners) {
                try {
                    listener.changedDescription(Trace.this, traceList.getDescription());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(TraceList traceList) {
            for (ITraceListener listener : Trace.this.listeners) {
                try {
                    listener.changedName(Trace.this, traceList.getName());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void eventAdded(TraceList trace2, ITraceEvent event) {
            TraceEvent newEvent = new TraceEvent(event);
            Trace.this.events.add(newEvent);
            for (ITraceListener listener : Trace.this.listeners) {
                try {
                    listener.addedEvent(Trace.this, newEvent);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

