/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.Function;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public final class ModuleHelpers {
    private ModuleHelpers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Address> getBasicBlockAddresses(Module module) throws CouldntLoadDataException {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        String string2 = String.valueOf("SELECT address FROM bn_codenode_instructions AS cit JOIN bn_nodes AS nt ON node_id = nt.id  JOIN bn_views AS vt ON nt.view_id = vt.id  WHERE position = 0 AND vt.type = 'native' AND cit.module_id = ");
        int n2 = module.getNative().getConfiguration().getId();
        String query = new StringBuilder(29 + String.valueOf(string2).length()).append(string2).append(n2).append(" GROUP BY address ").toString();
        try {
            HashSet<Address> addresses = new HashSet<Address>();
            try (ResultSet resultSet = module.getDatabase().executeQuery(query);){
                while (resultSet.next()) {
                    addresses.add(new Address(BigInteger.valueOf(resultSet.getLong("address"))));
                }
            }
            return addresses;
        }
        catch (SQLException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public static Function getFunction(Module module, Address address) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        for (Function function : module.getFunctions()) {
            if (!function.getAddress().equals(address)) continue;
            return function;
        }
        return null;
    }

    public static Function getFunction(Module module, long address) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        if (address < 0L) {
            throw new IllegalArgumentException("Error: Address argument can not be negative");
        }
        for (Function function : module.getFunctions()) {
            if (function.getAddress().toLong() != address) continue;
            return function;
        }
        return null;
    }

    public static Function getFunction(Module module, String name) {
        Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        Preconditions.checkNotNull(name, "Error: Name argument can not be null");
        for (Function function : module.getFunctions()) {
            if (!function.getName().equals(name)) continue;
            return function;
        }
        return null;
    }
}

