/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.IInstructionListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.disassembly.Operand;
import com.google.security.zynamics.binnavi.API.disassembly.OperandExpression;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.ReilGraph;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.REIL.ReilGraphConverter;
import com.google.security.zynamics.binnavi.disassembly.COperandTree;
import com.google.security.zynamics.binnavi.disassembly.COperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class Instruction
implements ApiObject<INaviInstruction> {
    private static final ReilTranslator<INaviInstruction> m_translator = new ReilTranslator();
    private final INaviInstruction m_instruction;
    private final List<Operand> m_operands = new ArrayList<Operand>();
    private ReilGraph m_reilGraph = null;
    private final InternalInstructionListener m_listener = new InternalInstructionListener();
    private final ListenerProvider<IInstructionListener> m_listeners = new ListenerProvider();

    public Instruction(INaviInstruction instruction) {
        this.m_instruction = Preconditions.checkNotNull(instruction, "Error: Instruction argument can't be null");
        for (COperandTree operand : this.m_instruction.getOperands()) {
            this.m_operands.add(new Operand(operand));
        }
        instruction.addListener(this.m_listener);
    }

    private static List<COperandTree> convert(INaviModule module, List<Operand> operands) {
        ArrayList<COperandTree> convertedOperands = new ArrayList<COperandTree>();
        for (Operand operand : operands) {
            convertedOperands.add(module.createOperand(Instruction.convert(module, operand.getRootNode(), null)));
        }
        return convertedOperands;
    }

    private static COperandTreeNode convert(INaviModule module, OperandExpression operandExpression, COperandTreeNode parent) {
        COperandTreeNode convertedNode = module.createOperandExpression(operandExpression.getNative().getValue(), operandExpression.getType().getNative());
        if (parent != null) {
            COperandTreeNode.link(parent, convertedNode);
        }
        for (OperandExpression child : operandExpression.getChildren()) {
            Instruction.convert(module, child, convertedNode);
        }
        return convertedNode;
    }

    public static Instruction create(Module module, Address address, String mnemonic, List<Operand> operands, byte[] data, String architecture) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        Preconditions.checkNotNull(mnemonic, "Error: Mnemonic argument can not be null");
        for (Operand operand : operands) {
            Preconditions.checkNotNull(operand, "Error: Operands list contains a null-argument");
        }
        Preconditions.checkNotNull(data, "Error: Data argument can not be null");
        return new Instruction(module.getNative().createInstruction(new CAddress(address.toLong()), mnemonic, Instruction.convert(module.getNative(), operands), data, architecture));
    }

    @Override
    public INaviInstruction getNative() {
        return this.m_instruction;
    }

    public void addListener(IInstructionListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<IComment> appendComment(String commentText) throws CouldntSaveDataException, CouldntLoadDataException {
        ArrayList<IComment> comments = Lists.newArrayList();
        try {
            comments = this.m_instruction.appendGlobalComment(commentText);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        for (IInstructionListener listener : this.m_listeners) {
            listener.appendedComment(this, Iterables.getLast(comments));
        }
        return comments;
    }

    public void deleteComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_instruction.deleteGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
        for (IInstructionListener listener : this.m_listeners) {
            listener.deletedComment(this, comment);
        }
    }

    public IComment editComment(IComment comment, String newComment) throws CouldntSaveDataException {
        IComment editedComment = null;
        try {
            editedComment = this.m_instruction.editGlobalComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        for (IInstructionListener listener : this.m_listeners) {
            listener.editedComment(this, comment);
        }
        return editedComment;
    }

    public Address getAddress() {
        return new Address(this.m_instruction.getAddress().toBigInteger());
    }

    public String getArchitecture() {
        return this.m_instruction.getArchitecture();
    }

    public List<IComment> getComment() {
        return this.m_instruction.getGlobalComment();
    }

    public byte[] getData() {
        return this.m_instruction.getData();
    }

    public String getMnemonic() {
        return this.m_instruction.getMnemonic();
    }

    public List<Operand> getOperands() {
        return new ArrayList<Operand>(this.m_operands);
    }

    public ReilGraph getReilCode() throws InternalTranslationException {
        if (this.m_reilGraph == null) {
            try {
                this.m_reilGraph = ReilGraphConverter.createReilGraph(m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), this.m_instruction));
            }
            catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
                throw new InternalTranslationException(e2, this);
            }
        }
        return this.m_reilGraph;
    }

    public void initializeComment(ArrayList<IComment> comment) {
        this.m_instruction.initializeGlobalComment(comment);
        for (IInstructionListener listener : this.m_listeners) {
            listener.initializedComment(this, comment);
        }
    }

    public void removeListener(IInstructionListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        StringBuffer instructionString = new StringBuffer(String.format("%s  %s ", this.getAddress().toHexString(), this.getMnemonic()));
        boolean addComma = false;
        for (Operand operand : this.getOperands()) {
            if (addComma) {
                instructionString.append(", ");
            }
            addComma = true;
            instructionString.append(operand.toString());
        }
        return instructionString.toString();
    }

    private class InternalInstructionListener
    implements com.google.security.zynamics.binnavi.disassembly.IInstructionListener {
        private InternalInstructionListener() {
        }

        @Override
        public void appendedComment(IInstruction instruction, IComment comment) {
            for (IInstructionListener listener : Instruction.this.m_listeners) {
                try {
                    listener.appendedComment(Instruction.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedComment(IInstruction instruction, IComment comment) {
            for (IInstructionListener listener : Instruction.this.m_listeners) {
                try {
                    listener.deletedComment(Instruction.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedComment(IInstruction instruction, IComment comment) {
            for (IInstructionListener listener : Instruction.this.m_listeners) {
                try {
                    listener.editedComment(Instruction.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedComment(IInstruction instruction, List<IComment> comment) {
            for (IInstructionListener listener : Instruction.this.m_listeners) {
                try {
                    listener.initializedComment(Instruction.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

