/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.IGroupNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNode;
import com.google.security.zynamics.binnavi.disassembly.INaviGroupNodeListener;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class GroupNode
extends ViewNode {
    private final INaviGroupNode m_node;
    private final List<ViewNode> m_elements = new ArrayList<ViewNode>();
    private final InternalListener m_internalListener = new InternalListener();
    private final ListenerProvider<IGroupNodeListener> m_listeners = new ListenerProvider();

    public GroupNode(View view, INaviGroupNode node, TagManager manager) {
        super(view, node, manager);
        this.m_node = node;
        this.m_node.addGroupListener(this.m_internalListener);
    }

    private ViewNode addElement(INaviViewNode node) {
        List<ViewNode> nodes = this.getView().getGraph().getNodes();
        for (ViewNode viewNode : nodes) {
            if (viewNode.getNative() != node) continue;
            this.m_elements.add(viewNode);
            return viewNode;
        }
        return null;
    }

    private ViewNode removeElement(INaviViewNode element) {
        for (ViewNode viewNode : this.m_elements) {
            if (viewNode.getNative() != element) continue;
            this.m_elements.remove(viewNode);
            return viewNode;
        }
        return null;
    }

    @Override
    protected String getName() {
        return String.format("Group Node [%d elements]", this.m_node.getNumberOfElements());
    }

    @Override
    public INaviGroupNode getNative() {
        return this.m_node;
    }

    public void addListener(IGroupNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void addNode(ViewNode node) {
        Preconditions.checkNotNull(node, "Error: Node argument can not be null");
        if (this.m_node.getElements().contains(node.getNative())) {
            if (!this.m_elements.contains(node)) {
                this.m_elements.add(node);
            }
        } else {
            this.m_node.addElement(node.getNative());
        }
    }

    public List<IComment> appendComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        try {
            return this.m_node.appendComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public void deleteComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.deleteComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public IComment editComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_node.editComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public List<IComment> getComment() {
        return this.m_node.getComments();
    }

    public List<ViewNode> getElements() {
        return new ArrayList<ViewNode>(this.m_elements);
    }

    public boolean isCollapsed() {
        return this.m_node.isCollapsed();
    }

    public void removeListener(IGroupNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void removeNode(ViewNode element) {
        Preconditions.checkNotNull(element, "Error: Element argument can not be null");
        this.m_node.removeElement(element.getNative());
    }

    public void setCollapsed(boolean collapsed) {
        this.m_node.setCollapsed(collapsed);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private class InternalListener
    implements INaviGroupNodeListener {
        private InternalListener() {
        }

        @Override
        public void addedElement(INaviGroupNode groupNode, INaviViewNode node) {
            ViewNode apiNode = GroupNode.this.addElement(node);
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.addedNode(GroupNode.this, apiNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void appendedGroupNodeComment(INaviGroupNode node, IComment comment) {
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.appendedComment(GroupNode.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedState(INaviGroupNode node) {
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.changedState(GroupNode.this, GroupNode.this.isCollapsed());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedGroupNodeComment(INaviGroupNode node, IComment comment) {
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.deletedComment(GroupNode.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedGroupNodeComment(INaviGroupNode node, IComment comment) {
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.editedComment(GroupNode.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedGroupNodeComment(INaviGroupNode node, List<IComment> comment) {
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.initializedComment(GroupNode.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedElement(INaviGroupNode groupNode, INaviViewNode node) {
            ViewNode apiNode = GroupNode.this.removeElement(node);
            GroupNode.this.m_elements.remove(apiNode);
            for (IGroupNodeListener listener : GroupNode.this.m_listeners) {
                try {
                    listener.removedNode(GroupNode.this, apiNode);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

