/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.BlockEdge;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.FlowGraph;
import com.google.security.zynamics.binnavi.API.disassembly.FunctionType;
import com.google.security.zynamics.binnavi.API.disassembly.IFunctionListener;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.ReilFunction;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.REIL.InstructionFinders;
import com.google.security.zynamics.binnavi.disassembly.IBlockEdge;
import com.google.security.zynamics.binnavi.disassembly.IBlockNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.disassembly.IFunction;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.graphs.DirectedGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class Function
implements ApiObject<INaviFunction> {
    private final INaviFunction m_function;
    private final Module m_module;
    private FlowGraph m_graph;
    private final ListenerProvider<IFunctionListener> m_listeners = new ListenerProvider();
    private final InternalListener m_listener = new InternalListener();
    private static final ReilTranslator<INaviInstruction> m_translator = new ReilTranslator();
    private ReilFunction m_reilGraph = null;

    public Function(Module module, INaviFunction function) {
        this.m_module = Preconditions.checkNotNull(module, "Error: Module argument can not be null");
        this.m_function = Preconditions.checkNotNull(function, "Error: Function argument can't be null");
        if (function.isLoaded()) {
            this.convertData();
        }
        function.addListener(this.m_listener);
    }

    private void convertData() {
        DirectedGraph<IBlockNode, IBlockEdge> graph = this.m_function.getGraph();
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
        ArrayList<BlockEdge> edges = new ArrayList<BlockEdge>();
        HashMap<IBlockNode, BasicBlock> blockMap = new HashMap<IBlockNode, BasicBlock>();
        for (IBlockNode block : graph.getNodes()) {
            BasicBlock newBlock = new BasicBlock(block, this);
            blockMap.put(block, newBlock);
            blocks.add(newBlock);
        }
        for (IBlockEdge edge : graph.getEdges()) {
            BasicBlock source = (BasicBlock)blockMap.get(edge.getSource());
            BasicBlock target = (BasicBlock)blockMap.get(edge.getTarget());
            edges.add(new BlockEdge(edge, source, target));
        }
        this.m_graph = new FlowGraph((List<BasicBlock>)blocks, (List<BlockEdge>)edges);
    }

    @Override
    public INaviFunction getNative() {
        return this.m_function;
    }

    public void addListener(IFunctionListener listener) {
        this.m_listeners.addListener(listener);
    }

    public List<IComment> appendComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        try {
            return this.m_function.appendGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public IComment editComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_function.editGlobalComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_function.deleteGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public void close() {
        this.m_graph = null;
        this.m_reilGraph = null;
        this.m_function.close();
        this.m_function.removeListener(this.m_listener);
    }

    public Address getAddress() {
        return new Address(this.m_function.getAddress().toBigInteger());
    }

    public int getBlockCount() {
        return this.m_function.getBasicBlockCount();
    }

    public List<IComment> getComment() {
        return this.m_function.getGlobalComment();
    }

    public String getDescription() {
        return this.m_function.getDescription();
    }

    public int getEdgeCount() {
        return this.m_function.getEdgeCount();
    }

    public FlowGraph getGraph() {
        if (!this.isLoaded()) {
            throw new IllegalArgumentException("Error: The function is not loaded");
        }
        return this.m_graph;
    }

    public Module getModule() {
        return this.m_module;
    }

    public String getName() {
        return this.m_function.getName();
    }

    public ReilFunction getReilCode() throws InternalTranslationException {
        if (!this.isLoaded()) {
            throw new IllegalStateException("Error: Function must be loaded first");
        }
        if (this.m_reilGraph == null) {
            try {
                this.m_reilGraph = new ReilFunction(m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), this.m_function));
            }
            catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
                throw new InternalTranslationException(e2, InstructionFinders.findInstruction(this, e2.getInstruction()));
            }
        }
        return this.m_reilGraph;
    }

    public FunctionType getType() {
        return FunctionType.convert(this.m_function.getType());
    }

    public boolean isLoaded() {
        return this.m_function.isLoaded();
    }

    public void load() throws CouldntLoadDataException {
        if (this.isLoaded()) {
            return;
        }
        try {
            this.m_function.load();
            this.convertData();
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException e2) {
            throw new CouldntLoadDataException(e2);
        }
    }

    public void removeListener(IFunctionListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setComment(ArrayList<IComment> comment) throws CouldntSaveDataException {
        try {
            this.m_function.initializeGlobalComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setDescription(String description) throws CouldntSaveDataException {
        try {
            this.m_function.setDescription(description);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void setName(String name) throws CouldntSaveDataException {
        try {
            this.m_function.setName(name);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public String toString() {
        return String.format("%s %s", this.getAddress().toHexString(), this.getName());
    }

    private class InternalListener
    implements com.google.security.zynamics.zylib.disassembly.IFunctionListener<IComment> {
        private InternalListener() {
        }

        @Override
        public void appendedComment(IFunction function, IComment comment) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.appendedComment(Function.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedDescription(IFunction function, String description) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.changedDescription(Function.this, description);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedName(IFunction function, String name) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.changedName(Function.this, name);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void changedForwardedFunction(IFunction function) {
        }

        @Override
        public void closed(IFunction function) {
            Function.this.m_graph = null;
            Function.this.m_reilGraph = null;
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.closedFunction(Function.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void deletedComment(IFunction function, IComment comment) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.deletedComment(Function.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void editedComment(IFunction function, IComment comment) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.editedComment(Function.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void initializedComment(IFunction function, List<IComment> comment) {
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.initializedComment(Function.this, comment);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void loadedFunction(IFunction function) {
            Function.this.convertData();
            for (IFunctionListener listener : Function.this.m_listeners) {
                try {
                    listener.loadedFunction(Function.this);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

