/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.BasicBlock;
import com.google.security.zynamics.binnavi.API.disassembly.FlowGraph;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;

public final class FlowGraphHelpers {
    private FlowGraphHelpers() {
    }

    public static Instruction getInstruction(FlowGraph flowgraph, Address address) {
        Preconditions.checkNotNull(flowgraph, "Error: Graph argument can not be null");
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        for (BasicBlock node : flowgraph) {
            for (Instruction instruction : node.getInstructions()) {
                if (!instruction.getAddress().equals(address)) continue;
                return instruction;
            }
        }
        return null;
    }

    public static Instruction getInstruction(FlowGraph graph, long address) {
        return FlowGraphHelpers.getInstruction(graph, new Address(address));
    }
}

