/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.DebuggerTemplate;
import com.google.security.zynamics.binnavi.API.disassembly.IDebuggerTemplateManagerListener;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class DebuggerTemplateManager {
    private final com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager m_manager;
    private final List<DebuggerTemplate> m_debuggerTemplates = new ArrayList<DebuggerTemplate>();
    private final ListenerProvider<IDebuggerTemplateManagerListener> m_listeners = new ListenerProvider();
    private final InternalDebuggerTemplateListener m_internalListener = new InternalDebuggerTemplateListener();

    public DebuggerTemplateManager(com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager manager) {
        this.m_manager = manager;
        this.m_manager.addListener(this.m_internalListener);
        for (com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debuggerTemplate : manager) {
            this.m_debuggerTemplates.add(new DebuggerTemplate(debuggerTemplate));
        }
    }

    public void addListener(IDebuggerTemplateManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public DebuggerTemplate createDebuggerTemplate(String name, String host, int port) throws CouldntSaveDataException {
        try {
            com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate newTemplate = this.m_manager.createDebugger(name, host, port);
            return ObjectFinders.getObject(newTemplate, this.m_debuggerTemplates);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException e2) {
            throw new CouldntSaveDataException(e2);
        }
    }

    public void deleteDebugger(DebuggerTemplate template) throws CouldntDeleteException {
        Preconditions.checkNotNull(template, "Error: Template argument can't be null");
        try {
            this.m_manager.removeDebugger(template.getNative());
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException e2) {
            throw new CouldntDeleteException(e2);
        }
    }

    public void dispose() {
        this.m_manager.removeListener(this.m_internalListener);
        for (DebuggerTemplate debuggerTemplate : this.m_debuggerTemplates) {
            debuggerTemplate.dispose();
        }
    }

    public DebuggerTemplate getDebuggerTemplate(int index) {
        return this.m_debuggerTemplates.get(index);
    }

    public int getDebuggerTemplateCount() {
        return this.m_debuggerTemplates.size();
    }

    public List<DebuggerTemplate> getDebuggerTemplates() {
        return new ArrayList<DebuggerTemplate>(this.m_debuggerTemplates);
    }

    public void removeListener(IDebuggerTemplateManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return String.format("Debugger Template Manager (%d templates)", this.m_debuggerTemplates.size());
    }

    private class InternalDebuggerTemplateListener
    implements com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener {
        private InternalDebuggerTemplateListener() {
        }

        @Override
        public void addedDebugger(com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager manager, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debugger) {
            DebuggerTemplate newTemplate = new DebuggerTemplate(debugger);
            DebuggerTemplateManager.this.m_debuggerTemplates.add(newTemplate);
            for (IDebuggerTemplateManagerListener listener : DebuggerTemplateManager.this.m_listeners) {
                try {
                    listener.addedDebuggerTemplate(DebuggerTemplateManager.this, newTemplate);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedDebugger(com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager manager, com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate debugger) {
            DebuggerTemplate deletedView = (DebuggerTemplate)ObjectFinders.getObject(debugger, DebuggerTemplateManager.this.m_debuggerTemplates);
            DebuggerTemplateManager.this.m_debuggerTemplates.remove(deletedView);
            for (IDebuggerTemplateManagerListener listener : DebuggerTemplateManager.this.m_listeners) {
                try {
                    listener.deletedDebuggerTemplate(DebuggerTemplateManager.this, deletedView);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

