/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.disassembly;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntDeleteException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.API.disassembly.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.API.disassembly.ICodeNodeListener;
import com.google.security.zynamics.binnavi.API.disassembly.Instruction;
import com.google.security.zynamics.binnavi.API.disassembly.TagManager;
import com.google.security.zynamics.binnavi.API.disassembly.View;
import com.google.security.zynamics.binnavi.API.disassembly.ViewNode;
import com.google.security.zynamics.binnavi.API.reil.InternalTranslationException;
import com.google.security.zynamics.binnavi.API.reil.ReilGraph;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.REIL.InstructionFinders;
import com.google.security.zynamics.binnavi.REIL.ReilGraphConverter;
import com.google.security.zynamics.binnavi.disassembly.CNaviCodeNodeListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ReilTranslator;
import com.google.security.zynamics.reil.translators.StandardEnvironment;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public final class CodeNode
extends ViewNode {
    private final INaviCodeNode m_node;
    private final List<Instruction> m_instructions = new ArrayList<Instruction>();
    private final ListenerProvider<ICodeNodeListener> m_listeners = new ListenerProvider();
    private final InternalListener m_internalListener = new InternalListener();
    private final ReilTranslator<INaviInstruction> m_translator = new ReilTranslator();
    private ReilGraph m_reilGraph;

    public CodeNode(View view, INaviCodeNode node, TagManager tagManager) {
        super(view, node, tagManager);
        this.m_node = node;
        for (INaviInstruction instruction : this.m_node.getInstructions()) {
            this.m_instructions.add(new Instruction(instruction));
        }
        node.addListener(this.m_internalListener);
    }

    @Override
    protected String getName() {
        return String.format("Code Node %s", this.m_node.getAddress().toHexString());
    }

    @Override
    public INaviCodeNode getNative() {
        return this.m_node;
    }

    public Instruction addInstruction(Instruction instruction) {
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can not be null");
        this.m_node.addInstruction(instruction.getNative(), null);
        return instruction;
    }

    public void addListener(ICodeNodeListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Address getAddress() {
        return new Address(this.m_node.getAddress().toBigInteger());
    }

    public List<IComment> getLocalComments() {
        return this.m_node.getComments().getLocalCodeNodeComment();
    }

    public List<IComment> getGlobalComments() {
        return this.m_node.getComments().getGlobalCodeNodeComment();
    }

    public void initializeLocalComment(List<IComment> comments) {
        this.m_node.getComments().initializeLocalCodeNodeComment(comments);
    }

    public void initializeGlobalComment(List<IComment> comments) {
        this.m_node.getComments().initializeGlobalCodeNodeComment(comments);
    }

    public void initializeLocalInstructionComment(Instruction instruction, List<IComment> comments) {
        this.m_node.getComments().initializeLocalInstructionComment(instruction.getNative(), comments);
    }

    public List<IComment> appendLocalComment(String comment) throws CouldntSaveDataException, CouldntLoadDataException {
        ArrayList<IComment> currentComments = new ArrayList();
        try {
            currentComments = this.m_node.getComments().appendLocalCodeNodeComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
        return currentComments;
    }

    public IComment editLocalComment(IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_node.getComments().editLocalCodeNodeComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteLocalComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.getComments().deleteLocalCodeNodeComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public List<IComment> appendGlobalComment(String comment) throws CouldntDeleteException, CouldntLoadDataException {
        try {
            return this.m_node.getComments().appendGlobalCodeNodeComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntDeleteException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public IComment editGlobalComment(IComment comment, String newComment) {
        try {
            this.m_node.getComments().editGlobalCodeNodeComment(comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            CUtilityFunctions.logException(exception);
        }
        return null;
    }

    public void deleteGlobalComment(IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.getComments().deleteGlobalCodeNodeComment(comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public IComment editLocalInstructionComment(Instruction instruction, IComment comment, String newComment) throws CouldntSaveDataException {
        try {
            return this.m_node.getComments().editLocalInstructionComment(instruction.getNative(), comment, newComment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntSaveDataException(exception);
        }
    }

    public void deleteLocalInstructionComment(Instruction instruction, IComment comment) throws CouldntDeleteException {
        try {
            this.m_node.getComments().deleteLocalInstructionComment(instruction.getNative(), comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException exception) {
            throw new CouldntDeleteException(exception);
        }
    }

    public List<IComment> appendLocalInstructionComment(Instruction instruction, String comment) throws CouldntDeleteException, CouldntLoadDataException {
        try {
            return this.m_node.getComments().appendLocalInstructionComment(instruction.getNative(), comment);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException exception) {
            throw new CouldntDeleteException(exception);
        }
        catch (com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException exception) {
            throw new CouldntLoadDataException(exception);
        }
    }

    public List<Instruction> getInstructions() {
        return new ArrayList<Instruction>(this.m_instructions);
    }

    public ReilGraph getReilCode() throws InternalTranslationException {
        if (this.m_reilGraph == null) {
            try {
                this.m_reilGraph = ReilGraphConverter.createReilGraph(this.m_translator.translate((ITranslationEnvironment)new StandardEnvironment(), (INaviInstruction)((Object)this.m_node)));
            }
            catch (com.google.security.zynamics.reil.translators.InternalTranslationException e2) {
                throw new InternalTranslationException(e2, InstructionFinders.findInstruction(this, e2.getInstruction()));
            }
        }
        return this.m_reilGraph;
    }

    public void removeInstruction(Instruction instruction) {
        Preconditions.checkNotNull(instruction, "Error: Instruction argument can not be null");
        this.m_node.removeInstruction(instruction.getNative());
    }

    public void removeListener(ICodeNodeListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setInstructionColor(Instruction instruction, int level, Color color) {
        Preconditions.checkNotNull(instruction, "Instruction argument can not be null");
        if (level < 10000) {
            throw new IllegalArgumentException("Drawing levels below 10000 are reserved for BinNavi");
        }
        this.m_node.setInstructionColor(instruction.getNative(), level, color);
    }

    @Override
    public String toString() {
        StringBuffer nodeString = new StringBuffer();
        for (Instruction instruction : this.m_instructions) {
            nodeString.append(instruction.toString());
            nodeString.append('\n');
        }
        return nodeString.toString();
    }

    private class InternalListener
    extends CNaviCodeNodeListenerAdapter {
        private InternalListener() {
        }

        @Override
        public void addedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            Instruction addedInstruction = new Instruction(instruction);
            CodeNode.this.m_instructions.add(addedInstruction);
            for (ICodeNodeListener listener : CodeNode.this.m_listeners) {
                try {
                    listener.addedInstruction(CodeNode.this, addedInstruction);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedInstruction(INaviCodeNode codeNode, INaviInstruction instruction) {
            Instruction removedInstruction = (Instruction)ObjectFinders.getObject(instruction, CodeNode.this.m_instructions);
            CodeNode.this.m_instructions.remove(removedInstruction);
            for (ICodeNodeListener listener : CodeNode.this.m_listeners) {
                try {
                    listener.removedInstruction(CodeNode.this, removedInstruction);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

