/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.IThreadListener;
import com.google.security.zynamics.binnavi.API.debug.Register;
import com.google.security.zynamics.binnavi.API.debug.ThreadState;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class Thread
implements ApiObject<TargetProcessThread> {
    private final TargetProcessThread m_thread;
    private final InternalThreadListener m_listener = new InternalThreadListener();
    private final ListenerProvider<IThreadListener> m_listeners = new ListenerProvider();

    public Thread(TargetProcessThread thread2) {
        Preconditions.checkNotNull(thread2, "Error: Thread argument can not be null");
        this.m_thread = thread2;
        this.m_thread.addListener(this.m_listener);
    }

    @Override
    public TargetProcessThread getNative() {
        return this.m_thread;
    }

    public void addListener(IThreadListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void dispose() {
        this.m_thread.removeListener(this.m_listener);
    }

    public Address getCurrentAddress() {
        return this.m_thread.getCurrentAddress() == null ? null : new Address(this.m_thread.getCurrentAddress().getAddress().toBigInteger());
    }

    public List<Register> getRegisters() {
        ArrayList<Register> registers = new ArrayList<Register>();
        for (RegisterValue register2 : this.m_thread.getRegisterValues()) {
            registers.add(new Register(register2));
        }
        return registers;
    }

    public ThreadState getState() {
        return ThreadState.convert(this.m_thread.getState());
    }

    public long getThreadId() {
        return this.m_thread.getThreadId();
    }

    public void removeListener(IThreadListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return String.format("Thread (TID: %d)", this.getThreadId());
    }

    private class InternalThreadListener
    implements ThreadListener {
        private InternalThreadListener() {
        }

        @Override
        public void instructionPointerChanged(TargetProcessThread thread2, RelocatedAddress oldAddress) {
            for (IThreadListener listener : Thread.this.m_listeners) {
                try {
                    listener.changedProgramCounter(Thread.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void registersChanged(TargetProcessThread thread2) {
            for (IThreadListener listener : Thread.this.m_listeners) {
                try {
                    listener.changedRegisters(Thread.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            for (IThreadListener listener : Thread.this.m_listeners) {
                try {
                    listener.changedState(Thread.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }
    }
}

