/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.security.zynamics.binnavi.API.debug.IProcessListener;
import com.google.security.zynamics.binnavi.API.debug.Memory;
import com.google.security.zynamics.binnavi.API.debug.MemoryMap;
import com.google.security.zynamics.binnavi.API.debug.MemoryModule;
import com.google.security.zynamics.binnavi.API.debug.TargetInformation;
import com.google.security.zynamics.binnavi.API.debug.Thread;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.util.ArrayList;
import java.util.List;

public final class Process {
    private final ProcessManager processManager;
    private final List<Thread> threads = new ArrayList<Thread>();
    private final List<MemoryModule> modules = new ArrayList<MemoryModule>();
    private MemoryMap memoryMap;
    private Memory memory;
    private TargetInformation targetInformation;
    private final InternalProcessListener listener = new InternalProcessListener();
    private final ListenerProvider<IProcessListener> listeners = new ListenerProvider();

    public Process(ProcessManager processManager) {
        this.processManager = processManager;
        processManager.addListener(this.listener);
        this.memory = new Memory(processManager.getMemory());
        this.targetInformation = processManager.getTargetInformation() == null ? null : new TargetInformation(processManager.getTargetInformation());
        this.memoryMap = new MemoryMap(processManager.getMemoryMap());
        for (TargetProcessThread thread2 : processManager.getThreads()) {
            this.threads.add(new Thread(thread2));
        }
        for (com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule module : processManager.getModules()) {
            this.modules.add(new MemoryModule(module));
        }
    }

    public void addListener(IProcessListener listener) {
        this.listeners.addListener(listener);
    }

    public Memory getMemory() {
        return this.memory;
    }

    public MemoryMap getMemoryMap() {
        return this.memoryMap;
    }

    public List<MemoryModule> getModules() {
        return new ArrayList<MemoryModule>(this.modules);
    }

    public TargetInformation getTargetInformation() {
        return this.targetInformation;
    }

    public List<Thread> getThreads() {
        return new ArrayList<Thread>(this.threads);
    }

    public void removeListener(IProcessListener listener) {
        this.listeners.removeListener(listener);
    }

    public String toString() {
        return String.format("Target Process", new Object[0]);
    }

    private class InternalProcessListener
    implements ProcessManagerListener {
        private InternalProcessListener() {
        }

        @Override
        public void addedModule(com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule module) {
            MemoryModule newModule = new MemoryModule(module);
            Process.this.modules.add(newModule);
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.addedModule(Process.this, newModule);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void addedThread(TargetProcessThread thread2) {
            Thread newThread = new Thread(thread2);
            Process.this.threads.add(newThread);
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.addedThread(Process.this, newThread);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void attached() {
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.attached(Process.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
        }

        @Override
        public void changedMemoryMap() {
            Process.this.memoryMap = new MemoryMap(Process.this.processManager.getMemoryMap());
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.changedMemoryMap(Process.this, Process.this.memoryMap);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void changedTargetInformation(com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation information) {
            for (Thread thread2 : Process.this.threads) {
                thread2.dispose();
            }
            Process.this.targetInformation = new TargetInformation(information);
            Process.this.modules.clear();
            Process.this.threads.clear();
            Process.this.memoryMap = new MemoryMap(new com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap(new ArrayList<MemorySection>()));
            Process.this.memory = new Memory(new com.google.security.zynamics.zylib.general.memmanager.Memory());
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.changedTargetInformation(Process.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void detached() {
            Process.this.targetInformation = null;
            Process.this.modules.clear();
            Process.this.threads.clear();
            Process.this.memoryMap = new MemoryMap(new com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap(new FilledList<MemorySection>()));
            Process.this.memory = new Memory(new com.google.security.zynamics.zylib.general.memmanager.Memory());
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.detached(Process.this);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void raisedException(DebuggerException exception) {
        }

        @Override
        public void removedModule(com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule module) {
            MemoryModule apiModule = (MemoryModule)ObjectFinders.getObject(module, Process.this.modules);
            Process.this.modules.remove(apiModule);
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.removedModule(Process.this, apiModule);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }

        @Override
        public void removedNonExistingModule(com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule module) {
        }

        @Override
        public void removedThread(TargetProcessThread thread2) {
            Thread apiThread = (Thread)ObjectFinders.getObject(thread2, Process.this.threads);
            Process.this.threads.remove(apiThread);
            for (IProcessListener listener : Process.this.listeners) {
                try {
                    listener.removedThread(Process.this, apiThread);
                }
                catch (Exception e2) {
                    CUtilityFunctions.logException(e2);
                }
            }
        }
    }
}

