/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;

public class DebuggerDebugException {
    private final DebuggerException debugException;

    public DebuggerDebugException(DebuggerException debugException) {
        this.debugException = Preconditions.checkNotNull(debugException, "Error: debugException argument can not be null");
    }

    public DebuggerDebugExceptionHandlingAction getExceptionAction() {
        return DebuggerDebugExceptionHandlingAction.convertTo(this.debugException.getExceptionAction());
    }

    public long getExceptionCode() {
        return this.debugException.getExceptionCode();
    }

    public String getExceptionName() {
        return this.debugException.getExceptionName();
    }

    public DebuggerException getNative() {
        return this.debugException;
    }

    static enum DebuggerDebugExceptionHandlingAction {
        Continue,
        Halt,
        Ignore;


        public static DebuggerDebugExceptionHandlingAction convertTo(DebuggerExceptionHandlingAction action) {
            switch (action) {
                case Continue: {
                    return Continue;
                }
                case Halt: {
                    return Halt;
                }
                case Ignore: {
                    return Ignore;
                }
            }
            return Continue;
        }

        public static DebuggerExceptionHandlingAction convertBack(DebuggerDebugExceptionHandlingAction action) {
            switch (action) {
                case Continue: {
                    return DebuggerExceptionHandlingAction.Continue;
                }
                case Halt: {
                    return DebuggerExceptionHandlingAction.Halt;
                }
                case Ignore: {
                    return DebuggerExceptionHandlingAction.Ignore;
                }
            }
            return DebuggerExceptionHandlingAction.Continue;
        }
    }
}

