/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.API.debug.Breakpoint;
import com.google.security.zynamics.binnavi.API.debug.IBreakpointManagerListener;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.API.disassembly.Module;
import com.google.security.zynamics.binnavi.APIHelpers.ApiObject;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BreakpointManager
implements ApiObject<com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager> {
    private final com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager breakpointManager;
    private final ListenerProvider<IBreakpointManagerListener> listeners = new ListenerProvider();
    private final InternalBreakpointManagerListener internalListener = new InternalBreakpointManagerListener();
    private final Map<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint, Breakpoint> breakpointMap = new HashMap<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint, Breakpoint>();
    private final Map<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint, Breakpoint> echoBreakpointMap = new HashMap<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint, Breakpoint>();

    public BreakpointManager(com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager breakpointManager) {
        this.breakpointManager = breakpointManager;
        breakpointManager.addListener(this.internalListener);
        for (com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint breakpoint : breakpointManager.getBreakpoints(BreakpointType.REGULAR)) {
            this.breakpointMap.put(breakpoint, new Breakpoint(breakpoint));
        }
        for (com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint breakpoint : breakpointManager.getBreakpoints(BreakpointType.ECHO)) {
            this.echoBreakpointMap.put(breakpoint, new Breakpoint(breakpoint));
        }
    }

    @Override
    public com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager getNative() {
        return this.breakpointManager;
    }

    public void addListener(IBreakpointManagerListener listener) {
        this.listeners.addListener(listener);
    }

    public Breakpoint getBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint internalBreakpoint = this.breakpointManager.getBreakpoint(BreakpointType.REGULAR, new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))));
        return this.breakpointMap.get(internalBreakpoint);
    }

    public List<Breakpoint> getBreakpoints() {
        return new ArrayList<Breakpoint>(this.breakpointMap.values());
    }

    public Breakpoint getEchoBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint internalBreakpoint = this.breakpointManager.getBreakpoint(BreakpointType.ECHO, new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))));
        return this.echoBreakpointMap.get(internalBreakpoint);
    }

    public List<Breakpoint> getEchoBreakpoints() {
        return new ArrayList<Breakpoint>(this.echoBreakpointMap.values());
    }

    public boolean hasBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        return this.breakpointManager.hasBreakpoint(BreakpointType.REGULAR, new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))));
    }

    public boolean hasEchoBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        return this.breakpointManager.hasBreakpoint(BreakpointType.ECHO, new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong()))));
    }

    public void removeBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        BreakpointStatus currentStatus = BreakpointStatus.BREAKPOINT_DELETING;
        BreakpointAddress breakpointAddress = new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong())));
        this.breakpointManager.setBreakpointStatus(Sets.newHashSet(breakpointAddress), BreakpointType.REGULAR, currentStatus);
    }

    public void removeEchoBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        this.breakpointManager.removeBreakpoints(BreakpointType.ECHO, Sets.newHashSet(new BreakpointAddress(module == null ? null : module.getNative(), new UnrelocatedAddress(new CAddress(address.toLong())))));
    }

    public void removeListener(IBreakpointManagerListener listener) {
        this.listeners.removeListener(listener);
    }

    public Breakpoint setBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        INaviModule realModule = module == null ? null : module.getNative();
        BreakpointAddress breakpointAddress = new BreakpointAddress(realModule, new UnrelocatedAddress(new CAddress(address.toLong())));
        HashSet<BreakpointAddress> breakpoints = Sets.newHashSet(breakpointAddress);
        this.breakpointManager.addBreakpoints(BreakpointType.REGULAR, breakpoints);
        return this.echoBreakpointMap.get(this.breakpointManager.getBreakpoint(BreakpointType.REGULAR, breakpointAddress));
    }

    public Breakpoint setEchoBreakpoint(Module module, Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        INaviModule realModule = module == null ? null : module.getNative();
        BreakpointAddress breakpointAddress = new BreakpointAddress(realModule, new UnrelocatedAddress(new CAddress(address.toLong())));
        HashSet<BreakpointAddress> breakpoints = Sets.newHashSet(breakpointAddress);
        this.breakpointManager.addBreakpoints(BreakpointType.ECHO, breakpoints);
        return this.echoBreakpointMap.get(this.breakpointManager.getBreakpoint(BreakpointType.ECHO, breakpointAddress));
    }

    public String toString() {
        return String.format("BreakpointManager (Managing %d Breakpoints)", this.breakpointManager.getNumberOfBreakpoints(BreakpointType.REGULAR));
    }

    private class InternalBreakpointManagerListener
    implements BreakpointManagerListener {
        private InternalBreakpointManagerListener() {
        }

        @Override
        public void breakpointsAdded(List<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint> breakpoints) {
            for (com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint breakpoint : breakpoints) {
                Breakpoint newBreakpoint = new Breakpoint(breakpoint);
                if (breakpoint.getType() == BreakpointType.REGULAR) {
                    BreakpointManager.this.breakpointMap.put(breakpoint, newBreakpoint);
                    for (IBreakpointManagerListener listener : BreakpointManager.this.listeners) {
                        try {
                            listener.addedBreakpoint(BreakpointManager.this, newBreakpoint);
                        }
                        catch (Exception exception) {
                            CUtilityFunctions.logException(exception);
                        }
                    }
                    continue;
                }
                if (breakpoint.getType() != BreakpointType.ECHO) continue;
                BreakpointManager.this.echoBreakpointMap.put(breakpoint, newBreakpoint);
                for (IBreakpointManagerListener listener : BreakpointManager.this.listeners) {
                    try {
                        listener.addedEchoBreakpoint(BreakpointManager.this, newBreakpoint);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void breakpointsConditionChanged(Set<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint> breakpoints) {
        }

        @Override
        public void breakpointsDescriptionChanged(Set<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint> breakpoints) {
        }

        @Override
        public void breakpointsRemoved(Set<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint> breakpoints) {
            Preconditions.checkNotNull(breakpoints, "Error: breakpoints argument can not be null");
            if (breakpoints.size() == 0) {
                return;
            }
            for (com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint breakpoint : breakpoints) {
                Breakpoint removedBreakpoint;
                if (breakpoint.getType() == BreakpointType.REGULAR) {
                    removedBreakpoint = (Breakpoint)BreakpointManager.this.breakpointMap.get(breakpoint);
                    BreakpointManager.this.breakpointMap.remove(breakpoint);
                    for (IBreakpointManagerListener listener : BreakpointManager.this.listeners) {
                        try {
                            listener.removedBreakpoint(BreakpointManager.this, removedBreakpoint);
                        }
                        catch (Exception exception) {
                            CUtilityFunctions.logException(exception);
                        }
                    }
                    continue;
                }
                if (breakpoint.getType() != BreakpointType.ECHO) continue;
                removedBreakpoint = (Breakpoint)BreakpointManager.this.echoBreakpointMap.get(breakpoint);
                BreakpointManager.this.echoBreakpointMap.remove(breakpoint);
                for (IBreakpointManagerListener listener : BreakpointManager.this.listeners) {
                    try {
                        listener.removedEchoBreakpoint(BreakpointManager.this, removedBreakpoint);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            }
        }

        @Override
        public void breakpointsStatusChanged(Map<com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint, BreakpointStatus> breakpointsToOldStatus, BreakpointStatus newStatus) {
        }
    }
}

