/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.API.debug;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.debug.Bookmark;
import com.google.security.zynamics.binnavi.API.debug.IBookmarkManagerListener;
import com.google.security.zynamics.binnavi.API.disassembly.Address;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.CBookmark;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import java.util.ArrayList;
import java.util.List;

public final class BookmarkManager {
    private final com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager m_bookmarkManager;
    private final List<Bookmark> m_bookmarks = new ArrayList<Bookmark>();
    private final ListenerProvider<IBookmarkManagerListener> m_listeners = new ListenerProvider();
    private final InternalBookmarkManagerListener m_internalBookmarkListener = new InternalBookmarkManagerListener();

    public BookmarkManager(com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager bookmarkManager) {
        this.m_bookmarkManager = bookmarkManager;
        for (CBookmark bookmark : this.m_bookmarkManager) {
            this.m_bookmarks.add(new Bookmark(bookmark));
        }
        this.m_bookmarkManager.addListener(this.m_internalBookmarkListener);
    }

    public void addBookmark(Address address, String description) {
        Preconditions.checkNotNull(address, "Error: Bookmark addresses can't be null");
        this.m_bookmarkManager.addBookmark(new CBookmark(new CAddress(address.toLong()), description));
    }

    public void addListener(IBookmarkManagerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public Bookmark getBookmark(Address address) {
        Preconditions.checkNotNull(address, "Error: Bookmark addresses argument can't be null");
        CBookmark bookmark = this.m_bookmarkManager.getBookmark(new CAddress(address.toLong()));
        return bookmark == null ? null : ObjectFinders.getObject(bookmark, this.m_bookmarks);
    }

    public Bookmark getBookmark(int index) {
        CBookmark bookmark = this.m_bookmarkManager.getBookmark(index);
        return ObjectFinders.getObject(bookmark, this.m_bookmarks);
    }

    public int getNumberOfBookmarks() {
        return this.m_bookmarkManager.getNumberOfBookmarks();
    }

    public void removeBookmark(Address address) {
        Preconditions.checkNotNull(address, "Error: Address argument can not be null");
        CBookmark bookmark = this.m_bookmarkManager.getBookmark(new CAddress(address.toLong()));
        Preconditions.checkNotNull(bookmark, "Error: No bookmark exists at the specified address");
        this.m_bookmarkManager.removeBookmark(bookmark);
    }

    public void removeListener(IBookmarkManagerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public String toString() {
        return String.format("Bookmark Manager (Managing %d Bookmarks)", this.getNumberOfBookmarks());
    }

    private class InternalBookmarkManagerListener
    implements com.google.security.zynamics.binnavi.models.Bookmarks.memory.IBookmarkManagerListener {
        private InternalBookmarkManagerListener() {
        }

        @Override
        public void addedBookmark(com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager manager, CBookmark bookmark) {
            Bookmark newBookmark = new Bookmark(bookmark);
            BookmarkManager.this.m_bookmarks.add(newBookmark);
            for (IBookmarkManagerListener listener : BookmarkManager.this.m_listeners) {
                try {
                    listener.addedBookmark(BookmarkManager.this, newBookmark);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void removedBookmark(com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager manager, CBookmark bookmark) {
            Bookmark internalBookmark = (Bookmark)ObjectFinders.getObject(bookmark, BookmarkManager.this.m_bookmarks);
            BookmarkManager.this.m_bookmarks.remove(internalBookmark);
            for (IBookmarkManagerListener listener : BookmarkManager.this.m_listeners) {
                try {
                    listener.removedBookmark(BookmarkManager.this, internalBookmark);
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }
    }
}

