/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import java.math.BigInteger;
import javax.annotation.Nullable;

@GwtCompatible
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x2) {
        if (x2 <= 0) {
            String string2 = String.valueOf(String.valueOf(role));
            int n2 = x2;
            throw new IllegalArgumentException(new StringBuilder(26 + string2.length()).append(string2).append(" (").append(n2).append(") must be > 0").toString());
        }
        return x2;
    }

    static long checkPositive(@Nullable String role, long x2) {
        if (x2 <= 0L) {
            String string2 = String.valueOf(String.valueOf(role));
            long l2 = x2;
            throw new IllegalArgumentException(new StringBuilder(35 + string2.length()).append(string2).append(" (").append(l2).append(") must be > 0").toString());
        }
        return x2;
    }

    static BigInteger checkPositive(@Nullable String role, BigInteger x2) {
        if (x2.signum() <= 0) {
            String string2 = String.valueOf(String.valueOf(role));
            String string3 = String.valueOf(String.valueOf(x2));
            throw new IllegalArgumentException(new StringBuilder(15 + string2.length() + string3.length()).append(string2).append(" (").append(string3).append(") must be > 0").toString());
        }
        return x2;
    }

    static int checkNonNegative(@Nullable String role, int x2) {
        if (x2 < 0) {
            String string2 = String.valueOf(String.valueOf(role));
            int n2 = x2;
            throw new IllegalArgumentException(new StringBuilder(27 + string2.length()).append(string2).append(" (").append(n2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static long checkNonNegative(@Nullable String role, long x2) {
        if (x2 < 0L) {
            String string2 = String.valueOf(String.valueOf(role));
            long l2 = x2;
            throw new IllegalArgumentException(new StringBuilder(36 + string2.length()).append(string2).append(" (").append(l2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static BigInteger checkNonNegative(@Nullable String role, BigInteger x2) {
        if (x2.signum() < 0) {
            String string2 = String.valueOf(String.valueOf(role));
            String string3 = String.valueOf(String.valueOf(x2));
            throw new IllegalArgumentException(new StringBuilder(16 + string2.length() + string3.length()).append(string2).append(" (").append(string3).append(") must be >= 0").toString());
        }
        return x2;
    }

    static double checkNonNegative(@Nullable String role, double x2) {
        if (!(x2 >= 0.0)) {
            String string2 = String.valueOf(String.valueOf(role));
            double d2 = x2;
            throw new IllegalArgumentException(new StringBuilder(40 + string2.length()).append(string2).append(" (").append(d2).append(") must be >= 0").toString());
        }
        return x2;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }

    private MathPreconditions() {
    }
}

