/*
 * Decompiled with CFR 0.152.
 */
package satDomain;

import bindead.debug.Benchmark;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import satDomain.CNFSolver;
import satDomain.Clause;
import satDomain.Config;
import satDomain.HashedSubstitution;
import satDomain.ListSubstitution;
import satDomain.NativeInverter;
import satDomain.NumDomain;
import satDomain.Renamer;
import satDomain.Substitution;

public class SatDomain
extends NumDomain<SatDomain> {
    private List<Clause> Cclauses = new LinkedList<Clause>();

    public SatDomain() {
    }

    private SatDomain(SatDomain other) {
        super(other);
        for (Clause c : other.Cclauses) {
            this.assumeClause(new Clause(c));
        }
    }

    public void addClausesToInverter(NativeInverter p) {
        for (Clause c : this.Cclauses) {
            int[] clause = c.getClause();
            p.addclause(clause);
        }
    }

    @Override
    public void assumeClause(int[] is) {
        for (int v : is) {
            assert (v != 0);
            assert (Math.abs(v) <= this.getLastVar());
        }
        this.assumeClause(new Clause(is));
    }

    public void assumeClause(Clause c) {
        this.Cclauses.add(c);
    }

    @Override
    public void assumeEquality(int iv1, int iv2) {
        if (iv1 == -iv2) {
            this.assumeUnsatisfiable();
        } else if (iv1 != iv2) {
            this.assumeClause(new int[]{-iv1, iv2});
            this.assumeClause(new int[]{iv1, -iv2});
        }
    }

    @Override
    public void assumeTwoBitSum(int x1f, int x0f, int y0f, int s1f, int s0f) {
        this.assumeClause(new int[]{-x1f, s1f});
        this.assumeClause(new int[]{-x0f, -y0f, s1f});
        this.assumeClause(new int[]{x1f, x0f, -s1f});
        this.assumeClause(new int[]{x1f, y0f, -s1f});
        this.assumeClause(new int[]{x1f, x0f, y0f, -s0f});
        this.assumeClause(new int[]{s0f, -x0f});
        this.assumeClause(new int[]{s0f, -y0f});
    }

    @Override
    public void assumeUnsatisfiable() {
        this.csetToBottom();
    }

    @Override
    public SatDomain copy() {
        return new SatDomain(this);
    }

    @Override
    public Substitution expand(String reason, Collection<Integer> fromSet) {
        HashedSubstitution renaming = new HashedSubstitution();
        for (int from : fromSet) {
            renaming.put(from, this.freshTopVar());
        }
        ListIterator<Clause> iter = this.Cclauses.listIterator();
        while (iter.hasNext()) {
            Clause clause = iter.next();
            if (!clause.containsAnyOf(fromSet)) continue;
            iter.add(clause.renamedClause(renaming));
        }
        return renaming;
    }

    public List<Integer> findConstants() {
        ArrayList<Integer> r = new ArrayList<Integer>();
        for (Clause c : this.Cclauses) {
            if (c.clause.length != 1) continue;
            r.add(c.clause[0]);
        }
        return r;
    }

    @Override
    public int freshTopVar() {
        Benchmark.count("fresh SAT vars", 1);
        return this.freshVarIndex();
    }

    public boolean isSubset(SatDomain other) {
        assert (other.getLastVar() == this.getLastVar());
        SatDomain thisN = new SatDomain(this);
        SatDomain otherN = new SatDomain(other);
        otherN.invert("isSubset", this.getLastVar());
        for (Clause c : otherN.Cclauses) {
            thisN.Cclauses.add(c);
        }
        boolean ready = thisN.isUnsatisfiable();
        return ready;
    }

    @Override
    public boolean isUnsatisfiable() {
        boolean satisfiable = this.createSolver().checkSat();
        return !satisfiable;
    }

    @Override
    public void joinWith(SatDomain other) {
        int d = this.freshTopVar();
        List<Clause> cls = this.Cclauses;
        this.Cclauses = new LinkedList<Clause>();
        this.caddAllWithLiteral(d, cls);
        this.caddAllWithLiteral(-d, other.Cclauses);
        this.setLastVar(Math.max(this.getLastVar(), other.getLastVar()));
    }

    public void mergeVars(int i, int j) {
        if (i == -j) {
            this.assumeUnsatisfiable();
        } else if (i != j) {
            Benchmark.log("mergeVars " + i + " == " + j);
            assert (i != j);
            assert (i != -j);
            LinkedList<Clause> cls = new LinkedList<Clause>();
            for (Clause c : this.Cclauses) {
                cls.add(c.mergeVars(i, j));
            }
            this.Cclauses = cls;
        }
    }

    public void project(List<Integer> renamings, boolean withCompression) {
        Benchmark.count("project", 1);
        int last = this.getLastVar();
        while (renamings.size() < last + 1) {
            renamings.add(0);
        }
        int[] onto = new int[last + 1];
        for (int i = 1; i < onto.length; ++i) {
            int nv = renamings.get(i);
            onto[i] = nv != 0 ? nv : last--;
        }
        this.crename(onto);
        if (withCompression) {
            this.invert("project 1", last);
            this.invert("project 2", last);
            assert (this.getLastVar() == last);
        }
    }

    @Override
    public void project(Renamer renamer, boolean withCompression) {
        this.project(renamer.renamings, withCompression);
    }

    @Override
    public int summarize(int discr, int a, int b) {
        int nf = this.freshTopVar();
        this.assumeClause(new int[]{discr, -nf, b});
        this.assumeClause(new int[]{discr, nf, -b});
        this.assumeClause(new int[]{-discr, -nf, a});
        this.assumeClause(new int[]{-discr, nf, -a});
        return nf;
    }

    public String toString() {
        if (!Config.showCNF) {
            return this.showInfo();
        }
        return this.toDetailedString();
    }

    void crename(int[] onto) {
        LinkedList<Clause> cls = new LinkedList<Clause>();
        ListSubstitution subst = new ListSubstitution(onto);
        for (Clause c : this.Cclauses) {
            cls.add(c.renamedClause(subst));
        }
        this.Cclauses = cls;
    }

    void csetToBottom() {
        this.csetToTop();
        this.Cclauses.add(new Clause(new int[0]));
    }

    void csetToTop() {
        this.Cclauses.clear();
    }

    boolean isTriviallyFalse() {
        for (Clause c : this.Cclauses) {
            if (c.clause.length != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    String showFlag(int f) {
        return (f > 0 ? "" : "!") + "x" + Math.abs(f);
    }

    @Override
    String toDetailedString() {
        String s1 = "";
        for (Clause clause : this.Cclauses) {
            s1 = s1 + clause.showDisjunction() + '\n';
        }
        String s = s1;
        return "CNF(" + this.getLastVar() + "), " + this.Cclauses.size() + " clauses\n" + s;
    }

    private void caddAllWithLiteral(int i, List<Clause> cls) {
        for (Clause c : cls) {
            this.Cclauses.add(c.append(i));
        }
    }

    private CNFSolver createSolver() {
        CNFSolver s = new CNFSolver(this.getLastVar());
        for (Clause clause : this.Cclauses) {
            s.addClause(clause);
        }
        return s;
    }

    private void invert(String reason, int last) {
        Benchmark.count("invert: " + reason, 1);
        Benchmark.count("invert", 1);
        if (this.Cclauses.size() == 0) {
            this.csetToBottom();
        } else if (this.isTriviallyFalse()) {
            this.csetToTop();
        } else {
            NativeInverter.invert(this, last);
        }
        this.setLastVar(last);
    }

    private String showInfo() {
        String s = "<CNF ";
        return "<CNF lastVar=" + this.getLastVar() + ", clauses=" + this.Cclauses.size() + ">";
    }
}

