/*
 * Decompiled with CFR 0.152.
 */
package rreil.tester.gdb;

import java.io.IOException;
import java.util.ArrayList;
import javalx.exceptions.UnimplementedException;
import rreil.tester.gdb.GdbConnection;
import rreil.tester.gdb.GdbPacket;
import rreil.tester.gdb.IGdbEventListener;
import rreil.tester.gdb.commands.GdbContinueCommand;
import rreil.tester.gdb.commands.GdbInsertBreakOrWatchPointCommand;
import rreil.tester.gdb.commands.GdbReadMemoryCommand;
import rreil.tester.gdb.commands.GdbReadRegistersCommand;
import rreil.tester.gdb.commands.GdbStepCommand;
import rreil.tester.gdb.responses.GdbMemoryResponse;
import rreil.tester.gdb.responses.GdbRegistersResponse;
import rreil.tester.gdb.responses.GdbResponseParser;
import rreil.tester.gdb.responses.GdbTResponse;
import rreil.tester.gdb.responses.IGdbResponse;

public class GdbCommunicator {
    private final ArrayList<IGdbEventListener> listeners = new ArrayList();
    private final GdbConnection c;

    public GdbCommunicator(GdbConnection c) {
        this.c = c;
    }

    public void addListener(IGdbEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IGdbEventListener listener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (this.listeners.get(i) != listener) continue;
            this.listeners.remove(i);
            break;
        }
    }

    private void handleResponse(IGdbResponse response) {
        switch (response.getType()) {
            case T: {
                GdbTResponse tResponse = (GdbTResponse)response;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).tResponseReceived(this, tResponse);
                }
                break;
            }
            case Registers: {
                GdbRegistersResponse registersResponse = (GdbRegistersResponse)response;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).registersResponseReceived(this, registersResponse);
                }
                break;
            }
            case Memory: {
                GdbMemoryResponse memoryResponse = (GdbMemoryResponse)response;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    this.listeners.get(i).memoryResponseReceived(this, memoryResponse);
                }
                break;
            }
        }
    }

    public IGdbResponse continueGdb() throws IOException, InterruptedException {
        GdbContinueCommand command = new GdbContinueCommand();
        this.c.send(new GdbPacket(command.commandString()));
        GdbPacket p = this.c.getNextPacket();
        this.c.acknowledgePacket(p);
        IGdbResponse response = GdbResponseParser.$.parse(command, p);
        this.handleResponse(response);
        return response;
    }

    public IGdbResponse step() throws IOException, InterruptedException {
        GdbStepCommand command = new GdbStepCommand();
        this.c.send(new GdbPacket(command.commandString()));
        GdbPacket p = this.c.getNextPacket();
        this.c.acknowledgePacket(p);
        IGdbResponse response = GdbResponseParser.$.parse(command, p);
        this.handleResponse(response);
        return response;
    }

    public IGdbResponse queryRegisters() throws IOException, InterruptedException {
        GdbReadRegistersCommand command = new GdbReadRegistersCommand();
        this.c.send(new GdbPacket(command.commandString()));
        GdbPacket p = this.c.getNextPacket();
        this.c.acknowledgePacket(p);
        IGdbResponse response = GdbResponseParser.$.parse(command, p);
        this.handleResponse(response);
        return response;
    }

    public IGdbResponse[] readMemory(MemorySpace space, int address, int length) throws IOException, InterruptedException {
        if (space == MemorySpace.Data) {
            address += 0x800000;
        }
        int chunk_size = 128;
        int chunks = (length + chunk_size) / chunk_size;
        IGdbResponse[] responses = new IGdbResponse[chunks];
        for (int i = 0; i < responses.length; ++i) {
            GdbReadMemoryCommand command = new GdbReadMemoryCommand(address, length > chunk_size ? chunk_size : length);
            this.c.send(new GdbPacket(command.commandString()));
            GdbPacket p = this.c.getNextPacket();
            this.c.acknowledgePacket(p);
            IGdbResponse response = GdbResponseParser.$.parse(command, p);
            this.handleResponse(response);
            length -= chunk_size;
            address += chunk_size;
            responses[i] = response;
        }
        return responses;
    }

    public void insertBreakpoint(int address) throws IOException, InterruptedException {
        this.c.send(new GdbPacket(new GdbInsertBreakOrWatchPointCommand(address).commandString()));
        this.c.acknowledgePacket(this.c.getNextPacket());
    }

    public void removeBreakpoint(int address) {
        throw new UnimplementedException();
    }

    public static enum MemorySpace {
        Program,
        Data;

    }
}

