/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.util;

import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import rreil.lang.BinOp;
import rreil.lang.ComparisonOp;
import rreil.lang.LinBinOp;
import rreil.lang.MemVar;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class RhsFactory {
    private static final RhsFactory instance = new RhsFactory();

    private RhsFactory() {
    }

    public static RhsFactory getInstance() {
        return instance;
    }

    public Rhs.Rvar variable(int size, int offset, MemVar id) {
        return new Rhs.Rvar(size, offset, id);
    }

    public Rhs.Address rreilAddress(int size, RReilAddr address) {
        return new Rhs.Address(size, address);
    }

    public Rhs.LinRval rreilAddressLin(int size, RReilAddr address) {
        return new Rhs.LinRval(this.rreilAddress(size, address));
    }

    public Rhs.Rlit literal(int size, BigInt value) {
        return new Rhs.Rlit(size, value);
    }

    public Rhs.Cmp comparison(Rhs.Lin left, ComparisonOp op, Rhs.Lin right) {
        return new Rhs.Cmp(left, op, right);
    }

    @Deprecated
    public Rhs.Cmp comparison(Rhs.Rval left, ComparisonOp op, Rhs.Rval right) {
        return new Rhs.Cmp(new Rhs.LinRval(left), op, new Rhs.LinRval(right));
    }

    public Rhs.Bin binary(Rhs.Rval left, BinOp op, Rhs.Rval right) {
        return new Rhs.Bin(left, op, right);
    }

    public Rhs.LinBin binary(Rhs.Lin left, LinBinOp op, Rhs.Lin right) {
        return new Rhs.LinBin(left, op, right);
    }

    @Deprecated
    public Rhs.LinBin binary(Rhs.Rval left, LinBinOp op, Rhs.Rval right) {
        return new Rhs.LinBin(new Rhs.LinRval(left), op, new Rhs.LinRval(right));
    }

    public Rhs.LinScale scale(Rhs.Lin opnd, BigInt _const) {
        return new Rhs.LinScale(opnd, _const);
    }

    public Rhs.LinRval linRval(Rhs.Rval rval) {
        return new Rhs.LinRval(rval);
    }

    public Rhs.SignExtend castSx(Rhs.Rval rhs) {
        return new Rhs.SignExtend(rhs);
    }

    public Rhs.Convert castZx(Rhs.Rval rhs) {
        return new Rhs.Convert(rhs);
    }

    public Rhs.RangeRhs arbitrary(int size) {
        return new Rhs.RangeRhs(size, Interval.unsignedTop(size));
    }

    public Rhs.RangeRhs top(int size) {
        return new Rhs.RangeRhs(size, Interval.TOP);
    }

    public Rhs.RangeRhs range(int size, Interval range) {
        return new Rhs.RangeRhs(size, range);
    }

    public Rhs.LinRval trueLin() {
        return new Rhs.LinRval(Rhs.Rlit.true_);
    }

    public Rhs.LinRval falseLin() {
        return new Rhs.LinRval(Rhs.Rlit.false_);
    }
}

