/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang.util;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javalx.numeric.BigInt;
import javalx.numeric.Interval;
import rreil.disassembler.OperandTree;
import rreil.lang.BinOp;
import rreil.lang.ComparisonOp;
import rreil.lang.Lhs;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.PrimitiveInstruction;
import rreil.lang.util.RReilFactory;

public class LowLevelToRReilTranslator {
    static final RReilFactory rreil = new RReilFactory();
    private static final Map<String, Cons> $ = new HashMap<String, Cons>();

    public static RReil translate(LowLevelRReil insn) {
        Cons cons = $.get(insn.mnemonic());
        if (cons != null) {
            return cons.translate(insn);
        }
        if (insn.mnemonic().startsWith("primop#")) {
            PrimitiveInstruction prim = (PrimitiveInstruction)insn;
            String name = insn.mnemonic().substring("primop#".length());
            LinkedList<Lhs> outArgs = new LinkedList<Lhs>();
            for (LowLevelRReilOpnd op : prim.getOutArgs()) {
                outArgs.add(LowLevelToRReilTranslator.translateRvar(op).asLhs());
            }
            LinkedList<Rhs.Rval> inArgs = new LinkedList<Rhs.Rval>();
            for (LowLevelRReilOpnd op : prim.getInArgs()) {
                inArgs.add(LowLevelToRReilTranslator.translateRval(op));
            }
            return rreil.primOp(insn.address(), name, outArgs, inArgs);
        }
        if (insn.mnemonic().startsWith("native#")) {
            String name = insn.mnemonic().substring("native#".length());
            Rhs.Rlit opnd = new Rhs.Rlit(1, BigInt.of(new BigInteger(insn.opcode())));
            return rreil.nativeInsn(insn.address(), name, opnd);
        }
        throw new IllegalArgumentException("Illegal RREIL instruction: " + insn);
    }

    private static Rhs.Rval translateAddr(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        int size = LowLevelRReilOpnd2.size();
        OperandTree.Node opnd = LowLevelRReilOpnd2.child();
        switch (opnd.getType()) {
            case Immi: {
                return rreil.literal(size, BigInt.of(((Number)opnd.getData()).longValue()));
            }
            case Sym: {
                return rreil.variable(size, 0, MemVar.getVarOrFresh((String)opnd.getData()));
            }
            case Op: {
                return LowLevelToRReilTranslator.translateSymbolWithOffset(opnd, size);
            }
        }
        throw new IllegalArgumentException("Invalid RREIL operand type: " + (Object)((Object)opnd.getType()));
    }

    private static Rhs.Address translateRaddr(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        int size = LowLevelRReilOpnd2.size();
        OperandTree.Node opnd = LowLevelRReilOpnd2.child();
        switch (opnd.getType()) {
            case Op: {
                if (!".".equals(opnd.getData())) {
                    throw new IllegalArgumentException("Invalid RREIL operand: " + (String)opnd.getData());
                }
                Number base = (Number)opnd.child(0).getData();
                Number offs = (Number)opnd.child(1).getData();
                return rreil.rreilAddress(size, RReilAddr.valueOf(base.longValue(), offs.intValue()));
            }
        }
        throw new IllegalArgumentException("Invalid RREIL operand type: " + (Object)((Object)opnd.getType()));
    }

    private static boolean isIntraRReilAddress(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        OperandTree.Node opnd = LowLevelRReilOpnd2.child();
        if (opnd.getType() == OperandTree.Type.Op) {
            return ".".equals(opnd.getData());
        }
        return false;
    }

    private static Rhs.Rvar translateSymbolWithOffset(OperandTree.Node opnd, int size) {
        String op = (String)opnd.getData();
        if ("/".equals(op)) {
            OperandTree.Node baseNode = opnd.child(0);
            OperandTree.Node offsNode = opnd.child(1);
            MemVar x = MemVar.getVarOrFresh((String)baseNode.getData());
            int offs = ((Number)offsNode.getData()).intValue();
            return rreil.variable(size, offs, x);
        }
        throw new IllegalArgumentException("Invalid RREIL operand: " + op);
    }

    public static Rhs.Rvar translateRvar(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        return (Rhs.Rvar)LowLevelToRReilTranslator.translateRval(LowLevelRReilOpnd2);
    }

    public static Rhs.Rval translateRval(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        int size = LowLevelRReilOpnd2.size();
        OperandTree.Node opnd = LowLevelRReilOpnd2.child();
        switch (opnd.getType()) {
            case Immi: {
                return rreil.literal(size, BigInt.of(((Number)opnd.getData()).longValue()));
            }
            case Sym: {
                return rreil.variable(size, 0, MemVar.getVarOrFresh((String)opnd.getData()));
            }
            case Op: {
                return LowLevelToRReilTranslator.translateSymbolWithOffset(opnd, size);
            }
        }
        throw new IllegalArgumentException("Invalid RREIL operand type: " + (Object)((Object)opnd.getType()));
    }

    public static Rhs translateRhs(LowLevelRReilOpnd LowLevelRReilOpnd2) {
        int size = LowLevelRReilOpnd2.size();
        OperandTree.Node opnd = LowLevelRReilOpnd2.child();
        switch (opnd.getType()) {
            case Immi: {
                return rreil.literal(size, BigInt.of(((Number)opnd.getData()).longValue()));
            }
            case Immr: {
                return rreil.range(size, (Interval)opnd.getData());
            }
            case Sym: {
                return rreil.variable(size, 0, MemVar.getVarOrFresh((String)opnd.getData()));
            }
            case Op: {
                return LowLevelToRReilTranslator.translateSymbolWithOffset(opnd, size);
            }
        }
        throw new IllegalArgumentException("Invalid RREIL operand type: " + (Object)((Object)opnd.getType()));
    }

    static {
        $.put("add", Cons.binary(BinOp.Add));
        $.put("and", Cons.binary(BinOp.And));
        $.put("divu", Cons.binary(BinOp.Divu));
        $.put("divs", Cons.binary(BinOp.Divs));
        $.put("mod", Cons.binary(BinOp.Mod));
        $.put("mul", Cons.binary(BinOp.Mul));
        $.put("or", Cons.binary(BinOp.Or));
        $.put("shl", Cons.binary(BinOp.Shl));
        $.put("shru", Cons.binary(BinOp.Shr));
        $.put("shrs", Cons.binary(BinOp.Shrs));
        $.put("sub", Cons.binary(BinOp.Sub));
        $.put("xor", Cons.binary(BinOp.Xor));
        $.put("cmpeq", Cons.comparison(ComparisonOp.Cmpeq));
        $.put("cmpneq", Cons.comparison(ComparisonOp.Cmpneq));
        $.put("cmples", Cons.comparison(ComparisonOp.Cmples));
        $.put("cmpleu", Cons.comparison(ComparisonOp.Cmpleu));
        $.put("cmplts", Cons.comparison(ComparisonOp.Cmplts));
        $.put("cmpltu", Cons.comparison(ComparisonOp.Cmpltu));
        $.put("mov", Cons.mov());
        $.put("sign-extend", Cons.movsx());
        $.put("convert", Cons.movzx());
        $.put("nop", Cons.nop());
        $.put("call", Cons.branch(RReil.Branch.BranchTypeHint.Call));
        $.put("return", Cons.branch(RReil.Branch.BranchTypeHint.Return));
        $.put("if", Cons.branch());
        $.put("load", Cons.load());
        $.put("store", Cons.store());
    }

    private static abstract class Cons {
        abstract RReil translate(LowLevelRReil var1);

        static Cons binary(final BinOp op) {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval left = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    Rhs.Rval right = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(2));
                    Rhs.Rvar lhs = LowLevelToRReilTranslator.translateRvar(insn.rreilOperand(0));
                    return rreil.assign(insn.address(), lhs.asLhs(), rreil.binary(left, op, right));
                }
            };
        }

        static Cons comparison(final ComparisonOp op) {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval left = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    Rhs.Rval right = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(2));
                    Rhs.Rvar lhs = LowLevelToRReilTranslator.translateRvar(insn.rreilOperand(0));
                    return rreil.assign(insn.address(), lhs.asLhs(), rreil.comparision(left, op, right));
                }
            };
        }

        static Cons load() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval source = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    Rhs.Rval target = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    return rreil.load(insn.address(), ((Rhs.Rvar)target).asLhs(), source);
                }
            };
        }

        static Cons store() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval source = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    Rhs.Rval target = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    return rreil.store(insn.address(), target, source);
                }
            };
        }

        static Cons mov() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval lhs = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    Rhs rhs = LowLevelToRReilTranslator.translateRhs(insn.rreilOperand(1));
                    return rreil.assign(insn.address(), ((Rhs.Rvar)lhs).asLhs(), rhs);
                }
            };
        }

        static Cons movsx() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval lhs = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    Rhs.Rval rhs = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    return rreil.assign(insn.address(), ((Rhs.Rvar)lhs).asLhs(), rreil.castSx(rhs));
                }
            };
        }

        static Cons movzx() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval lhs = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    Rhs.Rval rhs = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    return rreil.assign(insn.address(), ((Rhs.Rvar)lhs).asLhs(), rreil.castZx(rhs));
                }
            };
        }

        static Cons branch(final RReil.Branch.BranchTypeHint hint) {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    Rhs.Rval target = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(1));
                    return rreil.branchNative(insn.address(), target, hint);
                }
            };
        }

        static Cons branch() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    if (LowLevelToRReilTranslator.isIntraRReilAddress(insn.rreilOperand(1))) {
                        Rhs.Rval cond = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                        Rhs.Address addr = LowLevelToRReilTranslator.translateRaddr(insn.rreilOperand(1));
                        return rreil.branch(insn.address(), cond, addr);
                    }
                    Rhs.Rval cond = LowLevelToRReilTranslator.translateRval(insn.rreilOperand(0));
                    Rhs.Rval addr = LowLevelToRReilTranslator.translateAddr(insn.rreilOperand(1));
                    if (cond instanceof Rhs.Rlit) {
                        Rhs.Rlit lit = (Rhs.Rlit)cond;
                        if (lit.getValue().isZero()) {
                            return rreil.nop(insn.address());
                        }
                        return rreil.branchNative(insn.address(), addr, RReil.Branch.BranchTypeHint.Jump);
                    }
                    return rreil.branchNative(insn.address(), cond, addr);
                }
            };
        }

        static Cons nop() {
            return new Cons(){

                @Override
                RReil translate(LowLevelRReil insn) {
                    return rreil.nop(insn.address());
                }
            };
        }
    }
}

