/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import javalx.numeric.BigInt;
import javalx.numeric.FiniteRange;
import javalx.numeric.Interval;
import javalx.numeric.Range;
import rreil.lang.AssemblerParseable;
import rreil.lang.BinOp;
import rreil.lang.ComparisonOp;
import rreil.lang.Field;
import rreil.lang.Lhs;
import rreil.lang.LinBinOp;
import rreil.lang.MemVar;
import rreil.lang.RReilAddr;
import rreil.lang.Reconstructable;
import rreil.lang.util.RhsVisitor;

public abstract class Rhs
implements AssemblerParseable,
Reconstructable {
    public abstract <R, T> R accept(RhsVisitor<R, T> var1, T var2);

    public MemVar getRegionOrNull() {
        return null;
    }

    public Range getOffsetOrTop() {
        return Range.TOP;
    }

    public static final class Address
    extends Rval
    implements AssemblerParseable,
    Reconstructable {
        private final RReilAddr address;

        public Address(int size, RReilAddr address) {
            super(size);
            this.address = address;
        }

        public RReilAddr getAddress() {
            return this.address;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Address)) {
                return false;
            }
            Address other = (Address)obj;
            return !(this.address == null ? other.address != null : !this.address.equals(other.address));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Address(" + this.getSize() + ", " + this.address.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.address.toAssemblerString();
        }

        @Override
        public String toHexAssemblerString() {
            return this.toAssemblerString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.address);
            builder.append(':');
            builder.append(this.getSize());
            return builder.toString();
        }
    }

    public static final class RangeRhs
    extends SimpleExpression {
        private final Interval range;
        private final int size;

        public RangeRhs(int size, Interval range) {
            this.range = range;
            this.size = size;
        }

        public Interval getRange() {
            return this.range;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.range);
            builder.append(':');
            builder.append(this.size);
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RangeRhs)) {
                return false;
            }
            RangeRhs other = (RangeRhs)obj;
            if (this.range == null ? other.range != null : !this.range.equals(other.range)) {
                return false;
            }
            return this.size == other.size;
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.RangeRhs(" + this.size + ",  Interval.unsignedTop(" + this.size + "))";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.range);
            return builder.toString();
        }
    }

    public static final class Rlit
    extends Rval {
        public static final Rlit true_ = new Rlit(1, BigInt.of(1L));
        public static final Rlit false_ = new Rlit(1, BigInt.of(0L));
        private final BigInt value;

        public Rlit(int size, BigInt value) {
            super(size);
            this.value = value;
        }

        public BigInt getValue() {
            return this.value;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public StringBuilder asHexPrefix(StringBuilder builder) {
            return builder.append(this.value.toHexString()).append(':').append(this.getSize());
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Rlit)) {
                return false;
            }
            Rlit other = (Rlit)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Rlit(" + this.getSize() + ", BigInt.of(" + this.value.longValue() + "))";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.value);
            return builder.toString();
        }

        @Override
        public String toHexAssemblerString() {
            Address asAddress = new Address(0, RReilAddr.valueOf(this.value));
            return asAddress.toHexAssemblerString();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.value);
            builder.append(':');
            builder.append(this.getSize());
            return builder.toString();
        }

        public String toHexString() {
            StringBuilder builder = new StringBuilder();
            builder.append("0x");
            builder.append(this.value.toHexString());
            builder.append(':');
            builder.append(this.getSize());
            return builder.toString();
        }
    }

    public static final class Rvar
    extends Rval {
        private final MemVar region;
        public final int offset;

        public Rvar(int size, int offset, MemVar region) {
            super(size);
            this.region = region;
            this.offset = offset;
        }

        public MemVar getRegionId() {
            return this.region;
        }

        public Lhs asLhs() {
            return new Lhs(this.getSize(), this.offset, this.region);
        }

        public int getOffset() {
            return this.offset;
        }

        public FiniteRange bitsRange() {
            return Field.finiteRangeKey(this.offset, this.getSize());
        }

        @Override
        public MemVar getRegionOrNull() {
            return this.region;
        }

        @Override
        public Range getOffsetOrTop() {
            return Range.from(this.offset);
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.offset;
            result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Rvar)) {
                return false;
            }
            Rvar other = (Rvar)obj;
            if (this.offset != other.offset) {
                return false;
            }
            return !(this.region == null ? other.region != null : !this.region.equals(other.region));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Rvar(" + this.getSize() + ", " + this.offset + ", " + this.region.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.region);
            if (this.offset != 0) {
                builder.append("/");
                builder.append(this.offset);
            }
            return builder.toString();
        }

        @Override
        public String toHexAssemblerString() {
            throw new IllegalStateException("Variables cannot be printed in as values in hexadecimal.");
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.region.toString());
            builder.append(':').append(this.getSize());
            if (this.offset != 0) {
                builder.append('/').append(this.offset);
            }
            return builder.toString();
        }
    }

    public static abstract class Rval
    extends Rhs {
        private final int size;

        public Rval(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }

        public abstract String toHexAssemblerString();

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Rval)) {
                return false;
            }
            Rval other = (Rval)obj;
            return this.size == other.size;
        }
    }

    public static final class Convert
    extends Rhs {
        private final Rval rhs;

        public Convert(Rval rhs) {
            this.rhs = rhs;
        }

        public Rval getRhs() {
            return this.rhs;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Convert)) {
                return false;
            }
            Convert other = (Convert)obj;
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Convert(" + this.rhs.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.mnemonic();
        }

        public String mnemonic() {
            return "convert";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append(" ");
            builder.append(this.rhs);
            return builder.toString();
        }
    }

    public static final class SignExtend
    extends Rhs {
        private final Rval rhs;

        public SignExtend(Rval rhs) {
            this.rhs = rhs;
        }

        public Rval getRhs() {
            return this.rhs;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.rhs == null ? 0 : this.rhs.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SignExtend)) {
                return false;
            }
            SignExtend other = (SignExtend)obj;
            return !(this.rhs == null ? other.rhs != null : !this.rhs.equals(other.rhs));
        }

        @Override
        public String reconstructCode() {
            return "new SignExtend(" + this.rhs.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.mnemonic();
        }

        public String mnemonic() {
            return "sign-extend";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append(" ");
            builder.append(this.rhs);
            return builder.toString();
        }
    }

    public static final class Cmp
    extends SimpleExpression {
        private final ComparisonOp op;
        private final Lin left;
        private final Lin right;

        public Cmp(Lin left, ComparisonOp op, Lin right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public Lin getLeft() {
            return this.left;
        }

        public ComparisonOp getOp() {
            return this.op;
        }

        public Cmp not() {
            switch (this.op) {
                case Cmpeq: {
                    return new Cmp(this.left, ComparisonOp.Cmpneq, this.right);
                }
                case Cmpneq: {
                    return new Cmp(this.left, ComparisonOp.Cmpeq, this.right);
                }
                case Cmples: {
                    return new Cmp(this.right, ComparisonOp.Cmplts, this.left);
                }
                case Cmpleu: {
                    return new Cmp(this.right, ComparisonOp.Cmpltu, this.left);
                }
                case Cmplts: {
                    return new Cmp(this.right, ComparisonOp.Cmples, this.left);
                }
                case Cmpltu: {
                    return new Cmp(this.right, ComparisonOp.Cmpleu, this.left);
                }
            }
            throw new IllegalStateException();
        }

        public Lin getRight() {
            return this.right;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Cmp)) {
                return false;
            }
            Cmp other = (Cmp)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op != other.op) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Cmp(" + this.left.reconstructCode() + ", " + this.op.reconstructCode() + ", " + this.right.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.mnemonic();
        }

        public String mnemonic() {
            return this.op.asPrefix();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append(" ");
            builder.append(this.left);
            builder.append(", ");
            builder.append(this.right);
            return builder.toString();
        }
    }

    public static final class LinRval
    extends Lin {
        private final Rval val;

        public LinRval(Rval val) {
            this.val = val;
        }

        public Rval getRval() {
            return this.val;
        }

        @Override
        public int getSize() {
            return this.val.getSize();
        }

        @Override
        public MemVar getRegionOrNull() {
            return this.val.getRegionOrNull();
        }

        @Override
        public Range getOffsetOrTop() {
            return this.val.getOffsetOrTop();
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LinRval)) {
                return false;
            }
            LinRval other = (LinRval)obj;
            return !(this.val == null ? other.val != null : !this.val.equals(other.val));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.LinRval(" + this.val.reconstructCode() + ")";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.val);
            return builder.toString();
        }

        @Override
        public String mnemonic() {
            return "LinRval";
        }
    }

    public static final class LinScale
    extends Lin {
        private final Lin opnd;
        private final BigInt scale;

        public LinScale(Lin opnd, BigInt scale) {
            this.opnd = opnd;
            this.scale = scale;
        }

        public Lin getOpnd() {
            return this.opnd;
        }

        public BigInt getConst() {
            return this.scale;
        }

        @Override
        public int getSize() {
            return this.opnd.getSize();
        }

        @Override
        public MemVar getRegionOrNull() {
            return this.opnd.getRegionOrNull();
        }

        @Override
        public Range getOffsetOrTop() {
            return this.opnd.getOffsetOrTop();
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LinScale)) {
                return false;
            }
            LinScale other = (LinScale)obj;
            if (this.opnd == null ? other.opnd != null : !this.opnd.equals(other.opnd)) {
                return false;
            }
            return this.scale.equals(other.scale);
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.LinScale(" + this.opnd.reconstructCode() + ", BigInt.of(" + this.scale.longValue() + "))";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append("(");
            builder.append(this.scale);
            builder.append(", ");
            builder.append(this.opnd);
            builder.append(")");
            return builder.toString();
        }

        @Override
        public String mnemonic() {
            return "scale";
        }
    }

    public static final class LinBin
    extends Lin {
        private final LinBinOp op;
        private final Lin left;
        private final Lin right;

        public LinBin(Lin left, LinBinOp op, Lin right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public LinBinOp getOp() {
            return this.op;
        }

        public Lin getLeft() {
            return this.left;
        }

        public Lin getRight() {
            return this.right;
        }

        @Override
        public int getSize() {
            int size = this.left.getSize();
            assert (size == this.right.getSize()) : "Operands of binary linear expression must have the same size";
            return size;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LinBin)) {
                return false;
            }
            LinBin other = (LinBin)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op != other.op) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.LinBin(" + this.left.reconstructCode() + ", " + this.op.reconstructCode() + ", " + this.right.reconstructCode() + ")";
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append("(");
            builder.append(this.left);
            builder.append(", ");
            builder.append(this.right);
            builder.append(")");
            return builder.toString();
        }

        @Override
        public String mnemonic() {
            return this.op.asPrefix();
        }
    }

    public static abstract class Lin
    extends SimpleExpression {
        public abstract String mnemonic();

        @Override
        public String toAssemblerString() {
            return this.mnemonic();
        }

        public abstract int getSize();
    }

    public static abstract class SimpleExpression
    extends Rhs {
    }

    public static final class Bin
    extends Rhs {
        private final BinOp op;
        private final Rval left;
        private final Rval right;

        public Bin(Rval left, BinOp op, Rval right) {
            this.op = op;
            this.left = left;
            this.right = right;
        }

        public BinOp getOp() {
            return this.op;
        }

        public Rval getLeft() {
            return this.left;
        }

        public Rval getRight() {
            return this.right;
        }

        @Override
        public <R, T> R accept(RhsVisitor<R, T> visitor, T data) {
            return visitor.visit(this, data);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
            result = 31 * result + (this.op == null ? 0 : this.op.hashCode());
            result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Bin)) {
                return false;
            }
            Bin other = (Bin)obj;
            if (this.left == null ? other.left != null : !this.left.equals(other.left)) {
                return false;
            }
            if (this.op != other.op) {
                return false;
            }
            return !(this.right == null ? other.right != null : !this.right.equals(other.right));
        }

        @Override
        public String reconstructCode() {
            return "new Rhs.Bin(" + this.left.reconstructCode() + ", " + this.op.reconstructCode() + ", " + this.right.reconstructCode() + ")";
        }

        @Override
        public String toAssemblerString() {
            return this.mnemonic();
        }

        public String mnemonic() {
            return this.op.asPrefix();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.mnemonic());
            builder.append(" ");
            builder.append(this.left);
            builder.append(", ");
            builder.append(this.right);
            return builder.toString();
        }
    }
}

