/*
 * Decompiled with CFR 0.152.
 */
package rreil.lang;

import javalx.numeric.FiniteRange;
import rreil.lang.AssemblerParseable;
import rreil.lang.MemVar;
import rreil.lang.Reconstructable;
import rreil.lang.Rhs;

public final class Lhs
implements AssemblerParseable,
Reconstructable {
    private final MemVar region;
    private final int offset;
    private final int size;

    public Lhs(int size, int offset, MemVar regionId) {
        this.region = regionId;
        this.offset = offset;
        this.size = size;
        assert (size > 0) : "We do not support empty access ranges.";
    }

    public MemVar getRegionId() {
        return this.region;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getSize() {
        return this.size;
    }

    public Rhs.Rvar asRvar() {
        return new Rhs.Rvar(this.size, this.offset, this.region);
    }

    public FiniteRange bitRange() {
        return FiniteRange.of(this.getOffset(), (long)(this.getOffset() + this.getSize() - 1));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Lhs)) {
            return false;
        }
        Lhs other = (Lhs)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.region == null ? other.region != null : !this.region.equals(other.region)) {
            return false;
        }
        return this.size == other.size;
    }

    @Override
    public String reconstructCode() {
        return "new Lhs(" + this.size + ", " + this.offset + ", " + this.region.reconstructCode() + ")";
    }

    @Override
    public String toAssemblerString() {
        return this.region.toString();
    }

    public final String toString() {
        return this.asRvar().toString();
    }
}

