/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter;

import bindis.Disassembler;
import java.util.HashMap;
import java.util.Map;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import rreil.disassembler.Instruction;
import rreil.interpreter.MachineCtx;
import rreil.interpreter.RReilInterp;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.Rhs;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.util.RhsFactory;

public class RReilMachine {
    private static final int $DefaultPcBitWidth = 32;
    private static final RhsFactory exprs = RhsFactory.getInstance();
    private final Disassembler dis;
    private final Rhs.Rvar pc;

    public RReilMachine(Disassembler dis, int pcBitWidth) {
        this.dis = dis;
        this.pc = exprs.variable(pcBitWidth, 0, MemVar.getVarOrFresh("$pc"));
    }

    public RReilMachine(Disassembler dis) {
        this(dis, 32);
    }

    public void evalOne(MachineCtx ctx) {
        Instruction instruction = this.dis.decodeOne(ctx.getCode(), ctx.getOffset(), ctx.getStartPc());
        this.run(RReilMachine.buildInsnMap(instruction), ctx);
    }

    public void initPc(MachineCtx ctx) {
        ctx.getCtx().getRegisters().set(this.pc, BigInt.of(ctx.getStartPc()));
    }

    public void step(MachineCtx ctx) {
        BigInt currentPC = ctx.getCtx().getRegisters().get(this.pc);
        Instruction instruction = this.dis.decodeOne(ctx.getCode(), currentPC.intValue(), currentPC.longValue());
        currentPC = currentPC.add(BigInt.of(instruction.opcode().length));
        ctx.getCtx().getRegisters().set(this.pc, currentPC);
        System.out.println(instruction);
        this.run(RReilMachine.buildInsnMap(instruction), ctx);
    }

    private void run(Map<Integer, RReil> code, MachineCtx ctx) {
        RReilInterp interp = new RReilInterp(this.pc);
        BigInt currentPc = Bound.ZERO;
        while (true) {
            RReil insn = code.get(currentPc.intValue());
            currentPc = currentPc.add(Bound.ONE);
            if (insn == null) break;
            interp.run(insn, ctx.getCtx());
        }
    }

    private static Map<Integer, RReil> buildInsnMap(Instruction instruction) {
        HashMap<Integer, RReil> code = new HashMap<Integer, RReil>();
        for (LowLevelRReil insn : instruction.toRReilInstructions()) {
            RReil rreil = insn.toRReil();
            code.put(insn.address().offset(), rreil);
        }
        return code;
    }
}

