/*
 * Decompiled with CFR 0.152.
 */
package rreil.interpreter;

import javalx.numeric.BigInt;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.interpreter.MemoryModel;
import rreil.interpreter.RegisterModel;
import rreil.lang.Rhs;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.util.LowLevelToRReilTranslator;

public class InterpCtx {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final MemoryModel memory;
    private final RegisterModel registers;
    private final RegisterTranslator registerTranslator;

    public InterpCtx(int baseSize, RegisterTranslator registerTranslator, MemoryModel memory) {
        this(baseSize, registerTranslator, new RegisterModel(baseSize), memory);
    }

    public InterpCtx(int baseSize, RegisterTranslator registerTranslator, RegisterModel registerModel, MemoryModel memory) {
        this.registerTranslator = registerTranslator;
        this.memory = memory;
        this.registers = registerModel;
    }

    public MemoryModel getMemory() {
        return this.memory;
    }

    public RegisterModel getRegisters() {
        return this.registers;
    }

    public RegisterTranslator getRegisterTranslator() {
        return this.registerTranslator;
    }

    public void set(String name, BigInt value) {
        LowLevelRReilOpnd register = this.registerTranslator.translateRegister(name);
        Rhs.Rvar rreilVariable = LowLevelToRReilTranslator.translateRvar(register);
        this.registers.set(rreilVariable.asLhs(), value);
    }

    public BigInt get(String name) {
        LowLevelRReilOpnd register = this.registerTranslator.translateRegister(name);
        Rhs.Rvar rreilVariable = LowLevelToRReilTranslator.translateRvar(register);
        return this.registers.get(rreilVariable);
    }

    public BigInt getBool(String name) {
        Rhs.Rvar rreilVariable = LowLevelToRReilTranslator.translateRvar(factory.flag(name));
        return this.registers.get(rreilVariable);
    }

    public void setBool(String name, BigInt value) {
        Rhs.Rvar rreilVariable = LowLevelToRReilTranslator.translateRvar(factory.flag(name));
        this.registers.set(rreilVariable, value);
    }

    public BigInt getSigned(String name) {
        LowLevelRReilOpnd register = this.registerTranslator.translateRegister(name);
        Rhs.Rvar rreilVariable = LowLevelToRReilTranslator.translateRvar(register);
        return this.registers.getSigned(rreilVariable);
    }

    public BigInt load(int size, long address) {
        return this.memory.load(size, address);
    }

    public void store(int size, long address, BigInt value) {
        this.memory.store(size, address, value);
    }
}

