/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.exp_builder.statement;

import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.StatementCollection;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.exp_builder.StatementCollectionBuilder;
import rreil.gdsl.exp_builder.sexpr.SexprBuilder;
import rreil.gdsl.exp_builder.statement.StatementBuilder;
import rreil.lang.BinOp;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RhsFactory;

public class WhileBuilder
extends StatementBuilder {
    private SexprBuilder cond;
    private StatementCollectionBuilder body;

    public WhileBuilder(BuildingStateManager manager, SexprBuilder cond, StatementCollectionBuilder body) {
        super(manager);
        this.cond = cond.size(1);
        this.body = body;
    }

    @Override
    public BuildResult<? extends RReil> build() {
        RReilAddr startAddr = this.manager.stageAddress();
        BuildResult<? extends Rhs.Rval> condR = this.cond.buildRval();
        Rhs.Rvar temp = RhsFactory.getInstance().variable(1, 0, this.manager.nextTemporary());
        RReil.Assign negateRReil = RReilFactory.instance.assign(this.manager.nextAddress(), temp.asLhs(), RReilFactory.instance.binary(condR.getResult(), BinOp.Xor, (Rhs.Rval)Rhs.Rlit.true_));
        RReilAddr branchEndAddress = this.manager.nextAddress();
        BuildResult<StatementCollection> bodyR = this.body.build();
        RReil.BranchToRReil branchBackRReil = RReilFactory.instance.branch(this.manager.nextAddress(), Rhs.Rlit.true_, RhsFactory.getInstance().rreilAddress(64, startAddr));
        RReilAddr behindAddr = this.manager.stageAddress();
        RReil.BranchToRReil branchEndRReil = RReilFactory.instance.branch(branchEndAddress, temp, RhsFactory.getInstance().rreilAddress(64, behindAddr));
        SortedMap<RReilAddr, RReil> stmts = condR.getStatements();
        stmts.put(negateRReil.getRReilAddress(), negateRReil);
        stmts.putAll(bodyR.getResult().getInstructions());
        stmts.put(branchEndRReil.getRReilAddress(), branchEndRReil);
        return WhileBuilder.result(branchBackRReil, stmts);
    }
}

