/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.exp_builder;

import gdsl.rreil.expression.ICompare;
import java.util.SortedMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.BuildResult;
import rreil.gdsl.builder.Builder;
import rreil.gdsl.exp_builder.linear.LinearBuilder;
import rreil.lang.ComparisonOp;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RhsFactory;

public class CompareBuilder
extends Builder<Rhs>
implements ICompare {
    private LinearBuilder lhs;
    private LinearBuilder rhs;
    private ComparisonOp op;

    public CompareBuilder(BuildingStateManager manager, ComparisonOp op, LinearBuilder lhs, LinearBuilder rhs) {
        super(manager);
        this.op = op;
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public CompareBuilder size(int size) {
        this.lhs.size(size);
        this.rhs.size(size);
        return this;
    }

    @Override
    public BuildResult<? extends Rhs> build() {
        BuildResult<? extends Rhs.Rval> lhsR = this.lhs.buildRval();
        BuildResult<? extends Rhs.Rval> rhsR = this.rhs.buildRval();
        SortedMap<RReilAddr, RReil> stmts = lhsR.before(rhsR);
        return CompareBuilder.result(RhsFactory.getInstance().comparison(lhsR.getResult(), this.op, rhsR.getResult()), stmts);
    }

    @Override
    public int getSize() {
        return 1;
    }
}

