/*
 * Decompiled with CFR 0.152.
 */
package rreil.gdsl.builder;

import java.util.SortedMap;
import java.util.TreeMap;
import rreil.gdsl.BuildingStateManager;
import rreil.gdsl.builder.BuildResult;
import rreil.lang.MemVar;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;
import rreil.lang.util.RReilFactory;
import rreil.lang.util.RhsFactory;

public abstract class Builder<T> {
    protected BuildingStateManager manager;

    public Builder(BuildingStateManager manager) {
        this.manager = manager;
    }

    public abstract BuildResult<? extends T> build();

    public Builder<T> size(int size) {
        throw new RuntimeException("No size field");
    }

    public int getSize() {
        throw new RuntimeException("No size field");
    }

    protected static <T> BuildResult<T> result(T result, SortedMap<RReilAddr, RReil> stmts) {
        return new BuildResult<T>(result, stmts);
    }

    protected static <T> BuildResult<T> result(T result, RReil stmt) {
        TreeMap<RReilAddr, RReil> map = new TreeMap<RReilAddr, RReil>();
        map.put(stmt.getRReilAddress(), stmt);
        return new BuildResult<T>(result, map);
    }

    protected static <T> BuildResult<T> result(T result) {
        return new BuildResult<T>(result);
    }

    protected BuildResult<? extends Rhs.Rval> buildRval(Rhs from) {
        MemVar var = this.manager.nextTemporary();
        Rhs.Rvar temporary = RhsFactory.getInstance().variable(this.getSize(), 0, var);
        RReil.Assign assign = RReilFactory.instance.assign(this.manager.nextAddress(), temporary.asLhs(), from);
        return Builder.result(temporary, assign);
    }
}

