/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.x32;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class PushaTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        env.setCurrentInstruction(instruction);
        LowLevelRReilOpnd esp = registerTranslator.translateRegister("esp");
        LowLevelRReilOpnd edi = registerTranslator.translateRegister("edi");
        LowLevelRReilOpnd esi = registerTranslator.translateRegister("esi");
        LowLevelRReilOpnd ebp = registerTranslator.translateRegister("ebp");
        LowLevelRReilOpnd ebx = registerTranslator.translateRegister("ebx");
        LowLevelRReilOpnd edx = registerTranslator.translateRegister("edx");
        LowLevelRReilOpnd ecx = registerTranslator.translateRegister("ecx");
        LowLevelRReilOpnd eax = registerTranslator.translateRegister("eax");
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
        instructions.add(factory.MOV(env.getNextReilAddress(), tmp, esp));
        X86Helpers._PUSH(env, eax, instructions);
        X86Helpers._PUSH(env, ecx, instructions);
        X86Helpers._PUSH(env, edx, instructions);
        X86Helpers._PUSH(env, ebx, instructions);
        X86Helpers._PUSH(env, tmp, instructions);
        X86Helpers._PUSH(env, ebp, instructions);
        X86Helpers._PUSH(env, esi, instructions);
        X86Helpers._PUSH(env, edi, instructions);
    }
}

