/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.lowlevel.TranslationHelpers;

public class X86RmTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnEmitter emitter;

    public X86RmTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand);
        instructions.addAll(opnd.getInstructionStack());
        LowLevelRReilOpnd src = opnd.getOperandStack().pop();
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, src.size());
        this.emitter.emit(env, tmp, src, null, instructions);
        if (opnd.getOperandStack().size() >= 1) {
            LowLevelRReilOpnd addr = opnd.getOperandStack().pop();
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, tmp));
        } else {
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, src, tmp, instructions);
        }
    }

    public static class NotEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src, LowLevelRReilOpnd _null, List<LowLevelRReil> instructions) {
            instructions.add(factory.XOR(env.getNextReilAddress(), dst, src, TranslationHelpers.getMaxImmediate(src.size())));
        }
    }

    public static class NegEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src, LowLevelRReilOpnd _null, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd zxCond = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src.size());
            LowLevelRReilOpnd zero = factory.immediate(src.size(), (Number)0);
            LowLevelRReilOpnd f1 = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd f2 = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            instructions.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), zxCond, src, factory.immediate(src.size(), (Number)0)), factory.NOT(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, zxCond), factory.SIGNEXTEND(env.getNextReilAddress(), t, src), factory.MUL(env.getNextReilAddress(), dst, t, TranslationHelpers.getMaxImmediate(t.size())), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, dst, zero), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, zero), factory.CMPLES(env.getNextReilAddress(), f1, src, TranslationHelpers.getMinImmediateSigned(dst.size())), factory.CMPLES(env.getNextReilAddress(), f2, dst, TranslationHelpers.getMinImmediateSigned(dst.size())), factory.AND(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, f1, f2)));
        }
    }
}

