/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.lowlevel.TranslationHelpers;

public class X86RmRegRegTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final InsnEmitter emitter;

    public X86RmRegRegTranslator(InsnEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand1 = operands.get(0);
        OperandTree operand2 = operands.get(1);
        OperandTree operand3 = operands.get(2);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, operand1);
        TranslationState opnd2 = X86OperandTranslator.translateOperand(env, operand2);
        TranslationState opnd3 = X86OperandTranslator.translateOperand(env, operand3);
        instructions.addAll(opnd1.getInstructionStack());
        LowLevelRReilOpnd src1 = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd src2 = opnd2.getOperandStack().pop();
        LowLevelRReilOpnd src3 = opnd3.getOperandStack().pop();
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, src1.size());
        instructions.add(factory.MOV(env.getNextReilAddress(), tmp, src1));
        this.emitter.emit(env, tmp, src2, src3, instructions);
        if (opnd1.getOperandStack().size() >= 1) {
            LowLevelRReilOpnd addr = opnd1.getOperandStack().pop();
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, tmp));
        } else {
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, src1, tmp, instructions);
        }
    }

    public static class ShrdEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, LowLevelRReilOpnd src3, List<LowLevelRReil> instructions) {
            LowLevelRReilOpnd maxCnt;
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            int opndSz = src1.size();
            int preciseSz = TranslationHelpers.getNextSize(opndSz);
            LowLevelRReilOpnd a = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd b = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd c = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd r2 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd c2 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, opndSz);
            LowLevelRReilOpnd cntZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cntOutOfRange = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cntOne = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd bits = factory.immediate(preciseSz, (Number)opndSz);
            LowLevelRReilOpnd zero = factory.immediate(preciseSz, (Number)0);
            LowLevelRReilOpnd one = factory.immediate(preciseSz, (Number)1);
            instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), a, src1), factory.CONVERT(env.getNextReilAddress(), b, src2), factory.CONVERT(env.getNextReilAddress(), c, src3)));
            if (env.getDefaultArchitectureSize() == 64) {
                maxCnt = opndSz <= 32 ? bits : factory.immediate(preciseSz, (Number)64);
                instructions.add(factory.MOD(env.getNextReilAddress(), c, c, maxCnt));
            } else {
                maxCnt = bits;
            }
            long base = env.getBaseAddress();
            long reilBase = env.getCurrentReilOffset();
            long done = reilBase + 38L;
            long error = reilBase + 28L;
            long setOf = reilBase + 15L;
            long flags = setOf + 6L;
            instructions.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), cntZero, c, zero), factory.IFGOTORREIL(env.getNextReilAddress(), cntZero, base, done), factory.CMPLTU(env.getNextReilAddress(), cntOutOfRange, maxCnt, c), factory.IFGOTORREIL(env.getNextReilAddress(), cntOutOfRange, base, error), factory.SHL(env.getNextReilAddress(), b, b, bits), factory.OR(env.getNextReilAddress(), a, a, b), factory.SHRU(env.getNextReilAddress(), r, a, c), factory.CMPEQ(env.getNextReilAddress(), cntOne, c, one), factory.IFGOTORREIL(env.getNextReilAddress(), cntOne, base, setOf), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.GOTORREIL(env.getNextReilAddress(), base, flags), factory.XOR(env.getNextReilAddress(), t, src1, r.withSize(opndSz)), factory.MOV(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, t.withOffset(opndSz - 1, OperandSize.BIT)), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.XOR(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.OVERFLOW_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.SUB(env.getNextReilAddress(), c2, c, factory.immediate(preciseSz, (Number)1)), factory.SHRU(env.getNextReilAddress(), r2, a, c2), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, r2.withSize(OperandSize.BIT)), factory.MOV(env.getNextReilAddress(), src1, r.withSize(opndSz)), factory.OR(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, X86Helpers.BELOW_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), src1), factory.NOP(env.getNextReilAddress())));
        }
    }

    public static class ShldEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, LowLevelRReilOpnd src3, List<LowLevelRReil> instructions) {
            LowLevelRReilOpnd maxCnt;
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            int opndSz = src1.size();
            int preciseSz = TranslationHelpers.getNextSize(opndSz);
            LowLevelRReilOpnd a = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd b = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd c = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd r2 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd c2 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, opndSz);
            LowLevelRReilOpnd cntZero = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cntOutOfRange = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd cntOne = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd bits = factory.immediate(preciseSz, (Number)opndSz);
            LowLevelRReilOpnd zero = factory.immediate(preciseSz, (Number)0);
            LowLevelRReilOpnd one = factory.immediate(preciseSz, (Number)1);
            instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), a, src1), factory.CONVERT(env.getNextReilAddress(), b, src2), factory.CONVERT(env.getNextReilAddress(), c, src3)));
            if (env.getDefaultArchitectureSize() == 64) {
                maxCnt = opndSz <= 32 ? bits : factory.immediate(preciseSz, (Number)64);
                instructions.add(factory.MOD(env.getNextReilAddress(), c, c, maxCnt));
            } else {
                maxCnt = bits;
            }
            long base = env.getBaseAddress();
            long reilBase = env.getCurrentReilOffset();
            long done = reilBase + 39L;
            long error = reilBase + 29L;
            long setOf = reilBase + 16L;
            long flags = setOf + 6L;
            instructions.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), cntZero, c, zero), factory.IFGOTORREIL(env.getNextReilAddress(), cntZero, base, done), factory.CMPLTU(env.getNextReilAddress(), cntOutOfRange, maxCnt, c), factory.IFGOTORREIL(env.getNextReilAddress(), cntOutOfRange, base, error), factory.SHL(env.getNextReilAddress(), a, a, bits), factory.OR(env.getNextReilAddress(), a, a, b), factory.SHL(env.getNextReilAddress(), r, a, c), factory.SHRU(env.getNextReilAddress(), r, r, bits), factory.CMPEQ(env.getNextReilAddress(), cntOne, c, one), factory.IFGOTORREIL(env.getNextReilAddress(), cntOne, base, setOf), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.GOTORREIL(env.getNextReilAddress(), base, flags), factory.XOR(env.getNextReilAddress(), t, src1, r.withSize(opndSz)), factory.MOV(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, t.withOffset(opndSz - 1, OperandSize.BIT)), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, r.withSize(opndSz), zero.withSize(opndSz)), factory.XOR(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.OVERFLOW_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.SUB(env.getNextReilAddress(), c2, c, factory.immediate(preciseSz, (Number)1)), factory.SHL(env.getNextReilAddress(), r2, a, c2), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, r2.withOffset(preciseSz - 1, 1)), factory.MOV(env.getNextReilAddress(), src1, r.withSize(opndSz)), factory.OR(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, X86Helpers.BELOW_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), src1), factory.NOP(env.getNextReilAddress())));
        }
    }
}

