/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;
import rreil.lang.lowlevel.TranslationHelpers;

public class X86FlagHelpers {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    public static class LogicFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            LowLevelRReilOpnd zero = factory.immediate(dst.size(), (Number)0);
            LowLevelRReilOpnd zeroFlag = factory.immediate(X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND.size(), (Number)0);
            instructions.addAll(Arrays.asList(factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, zeroFlag), factory.MOV(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, zeroFlag), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, dst, zero), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, zero), factory.MOV(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.MOV(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND)));
        }
    }

    public static class IncFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            int preciseSz = TranslationHelpers.getNextSize(dst.size());
            LowLevelRReilOpnd t1 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd t2 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd t3 = registerTranslator.temporaryRegister(env, preciseSz);
            LowLevelRReilOpnd f1 = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd f2 = registerTranslator.temporaryRegister(env, OperandSize.BIT);
            LowLevelRReilOpnd zero = factory.immediate(dst.size(), (Number)0);
            LowLevelRReilOpnd max = TranslationHelpers.getMaxImmediateSigned(dst.size()).withSize(preciseSz);
            LowLevelRReilOpnd min = TranslationHelpers.getMinImmediateSigned(dst.size()).withSize(preciseSz);
            instructions.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, dst, zero), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, zero), factory.SIGNEXTEND(env.getNextReilAddress(), t1, src1), factory.SIGNEXTEND(env.getNextReilAddress(), t2, src2), factory.ADD(env.getNextReilAddress(), t3, t1, t2), factory.CMPLTS(env.getNextReilAddress(), f1, max, t3), factory.CMPLTS(env.getNextReilAddress(), f2, t3, min), factory.OR(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, f1, f2), factory.XOR(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.OVERFLOW_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class DecFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.addAll(Arrays.asList(factory.CMPLTS(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, src1, src2), factory.CMPLES(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, src1, src2), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, src1, src2), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, factory.immediate(dst.size(), (Number)0)), factory.XOR(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND)));
        }
    }

    public static class SubFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.addAll(Arrays.asList(factory.CMPLTU(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, src1, src2), factory.CMPLEU(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, src1, src2), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, src1, src2), factory.CMPLES(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, src1, src2), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, src1, src2), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, factory.immediate(dst.size(), (Number)0)), factory.XOR(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND)));
        }
    }

    public static class AddFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            RegisterTranslator registerTranslator = env.getRegisterTranslator();
            LowLevelRReilOpnd tmp1 = registerTranslator.temporaryRegister(env, dst.size());
            LowLevelRReilOpnd tmp2 = registerTranslator.temporaryRegister(env, dst.size());
            LowLevelRReilOpnd tmp3 = registerTranslator.temporaryRegister(env, dst.size());
            LowLevelRReilOpnd tmp4 = registerTranslator.temporaryRegister(env, dst.size());
            LowLevelRReilOpnd zero = factory.immediate(dst.size(), (Number)0);
            LowLevelRReilOpnd max = factory.immediate(dst.size(), (Number)-1);
            instructions.addAll(Arrays.asList(factory.SUB(env.getNextReilAddress(), tmp1, max, src2), factory.CMPLTU(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND, tmp1, src1), factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, dst, zero), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, zero), factory.XOR(env.getNextReilAddress(), tmp2, dst, src1), factory.XOR(env.getNextReilAddress(), tmp3, dst, src2), factory.AND(env.getNextReilAddress(), tmp4, tmp2, tmp3), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND, tmp4, zero), factory.OR(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, X86Helpers.BELOW_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.XOR(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.OVERFLOW_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND)));
        }
    }

    public static class ZeroSignFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd unused1, LowLevelRReilOpnd unused2, List<LowLevelRReil> instructions) {
            LowLevelRReilOpnd zero = factory.immediate(dst.size(), (Number)0);
            instructions.addAll(Arrays.asList(factory.CMPEQ(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND, dst, zero), factory.CMPLTS(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND, dst, zero), factory.OR(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND, X86Helpers.BELOW_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND), factory.XOR(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND, X86Helpers.SIGN_FLAG_OPERAND, X86Helpers.OVERFLOW_FLAG_OPERAND), factory.OR(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND, X86Helpers.LESS_FLAG_OPERAND, X86Helpers.EQUAL_FLAG_OPERAND)));
        }
    }

    public static class UndefineFlagEmitter
    implements InsnEmitter {
        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.addAll(Arrays.asList(factory.UNDEF(env.getNextReilAddress(), X86Helpers.AUXILIARY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.PARITY_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.SIGN_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.OVERFLOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.BELOW_OR_EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.EQUAL_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_FLAG_OPERAND), factory.UNDEF(env.getNextReilAddress(), X86Helpers.LESS_OR_EQUAL_FLAG_OPERAND)));
        }
    }
}

