/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class StosTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private final OperandSize elementSize;

    public StosTranslator(OperandSize elementSize) {
        this.elementSize = elementSize;
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd di = registerTranslator.translateRegister("edi").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd ax = registerTranslator.translateRegister("eax").withSize(this.elementSize);
        LowLevelRReilOpnd idx = factory.immediate(di.size(), (Number)this.elementSize.getSizeInBytes());
        instructions.add(factory.STORE(env.getNextReilAddress(), di, ax));
        long base = env.getBaseAddress();
        long reilBase = env.getCurrentReilOffset();
        long doDecrement = 3L + reilBase;
        long done = 1L + doDecrement;
        instructions.addAll(Arrays.asList(factory.IFGOTORREIL(env.getNextReilAddress(), X86Helpers.DIRECTION_FLAG_OPERAND, base, doDecrement), factory.ADD(env.getNextReilAddress(), di, di, idx), factory.GOTORREIL(env.getNextReilAddress(), base, done), factory.SUB(env.getNextReilAddress(), di, di, idx), factory.NOP(env.getNextReilAddress())));
    }
}

