/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.disassembler.translators.x86.common.X86RmRmTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class SarTranslator
extends X86RmRmTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    public SarTranslator() {
        super(new X86RmRmTranslator.SarEmitter());
    }

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        OperandTree sourceOperand = operands.get(1);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand);
        TranslationState opnd2 = X86OperandTranslator.translateOperand(env, sourceOperand);
        instructions.addAll(opnd1.getInstructionStack());
        instructions.addAll(opnd2.getInstructionStack());
        LowLevelRReilOpnd src1 = opnd1.getOperandStack().pop();
        LowLevelRReilOpnd src2 = factory.immediateSizeFixup(src1.size(), opnd2.getOperandStack().pop());
        LowLevelRReilOpnd tmp = registerTranslator.temporaryRegister(env, src1.size());
        this.emitter.emit(env, tmp, src1, src2, instructions);
        if (opnd1.getOperandStack().size() >= 1) {
            LowLevelRReilOpnd addr = opnd1.getOperandStack().pop();
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, tmp));
        } else {
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, src1, tmp, instructions);
        }
    }
}

