/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class LeaTranslator
implements InsnTranslator {
    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        OperandTree sourceOperand = operands.get(1);
        TranslationState opnd1 = X86OperandTranslator.translateOperand(env, targetOperand, false);
        TranslationState opnd2 = X86OperandTranslator.translateOperand(env, sourceOperand, false);
        instructions.addAll(opnd1.getInstructionStack());
        instructions.addAll(opnd2.getInstructionStack());
        assert (opnd1.getOperandStack().size() == 1) : "Destination operand must be a register";
        LowLevelRReilOpnd dst = opnd1.getOperandStack().pop();
        opnd2.getOperandStack().pop();
        LowLevelRReilOpnd addr = opnd2.getOperandStack().pop();
        X86Helpers.emitWritebackAndMaybeZeroExtend(env, dst, addr.withSize(dst.size()), instructions);
    }
}

