/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86FlagHelpers;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class DivTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private static final InsnEmitter emitter = new X86FlagHelpers.UndefineFlagEmitter();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand);
        instructions.addAll(opnd.getInstructionStack());
        LowLevelRReilOpnd divisor = opnd.getOperandStack().pop();
        int size = divisor.size();
        switch (size) {
            case 8: {
                LowLevelRReilOpnd ax = registerTranslator.translateRegister("ax");
                LowLevelRReilOpnd ah = registerTranslator.translateRegister("ah");
                LowLevelRReilOpnd al = registerTranslator.translateRegister("al");
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.WORD);
                LowLevelRReilOpnd q = registerTranslator.temporaryRegister(env, OperandSize.WORD);
                LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, OperandSize.WORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), t, divisor), factory.DIVU(env.getNextReilAddress(), q, ax, t), factory.MOD(env.getNextReilAddress(), r, ax, t), factory.MOV(env.getNextReilAddress(), ah, r.withSize(OperandSize.BYTE.getBits())), factory.MOV(env.getNextReilAddress(), al, q.withSize(OperandSize.BYTE.getBits()))));
                break;
            }
            case 16: {
                LowLevelRReilOpnd dx = registerTranslator.translateRegister("dx");
                LowLevelRReilOpnd ax = registerTranslator.translateRegister("ax");
                LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                LowLevelRReilOpnd q = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, OperandSize.DWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), t, divisor), factory.MOV(env.getNextReilAddress(), src.withSize(OperandSize.WORD), ax), factory.MOV(env.getNextReilAddress(), src.withOffset(16, OperandSize.WORD), dx), factory.DIVU(env.getNextReilAddress(), q, src, t), factory.MOD(env.getNextReilAddress(), r, src, t), factory.MOV(env.getNextReilAddress(), dx, r.withSize(OperandSize.WORD)), factory.MOV(env.getNextReilAddress(), ax, q.withSize(OperandSize.WORD))));
                break;
            }
            case 32: {
                LowLevelRReilOpnd edx = registerTranslator.translateRegister("edx");
                LowLevelRReilOpnd eax = registerTranslator.translateRegister("eax");
                LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                LowLevelRReilOpnd q = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), t, divisor), factory.MOV(env.getNextReilAddress(), src.withSize(OperandSize.DWORD), eax), factory.MOV(env.getNextReilAddress(), src.withOffset(32, OperandSize.DWORD), edx), factory.DIVU(env.getNextReilAddress(), q, src, t), factory.MOD(env.getNextReilAddress(), r, src, t)));
                X86Helpers.emitWritebackAndMaybeZeroExtend(env, eax, q.withSize(OperandSize.DWORD), instructions);
                X86Helpers.emitWritebackAndMaybeZeroExtend(env, edx, r.withSize(OperandSize.DWORD), instructions);
                break;
            }
            case 64: {
                LowLevelRReilOpnd rdx = registerTranslator.translateRegister("rdx");
                LowLevelRReilOpnd rax = registerTranslator.translateRegister("rax");
                LowLevelRReilOpnd src = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                LowLevelRReilOpnd q = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                LowLevelRReilOpnd r = registerTranslator.temporaryRegister(env, OperandSize.OWORD);
                instructions.addAll(Arrays.asList(factory.CONVERT(env.getNextReilAddress(), t, divisor), factory.MOV(env.getNextReilAddress(), src.withSize(OperandSize.QWORD), rax), factory.MOV(env.getNextReilAddress(), src.withOffset(64, OperandSize.QWORD), rdx), factory.DIVU(env.getNextReilAddress(), q, src, t), factory.MOD(env.getNextReilAddress(), r, src, t), factory.MOV(env.getNextReilAddress(), rdx, r.withSize(OperandSize.QWORD)), factory.MOV(env.getNextReilAddress(), rax, q.withSize(OperandSize.QWORD))));
                break;
            }
            default: {
                throw new RuntimeException("Error: Invalid operand size");
            }
        }
        emitter.emit(env, null, null, null, instructions);
    }
}

