/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86FlagHelpers;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class DecTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();
    private static final InsnEmitter emitter = new X86FlagHelpers.DecFlagEmitter();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        env.setCurrentInstruction(instruction);
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree operand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, operand);
        instructions.addAll(opnd.getInstructionStack());
        if (opnd.getOperandStack().size() > 1) {
            LowLevelRReilOpnd src = opnd.getOperandStack().pop();
            LowLevelRReilOpnd addr = opnd.getOperandStack().pop();
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src.size());
            LowLevelRReilOpnd one = factory.immediate(src.size(), (Number)1);
            instructions.add(factory.SUB(env.getNextReilAddress(), t, src, one));
            emitter.emit(env, t, src, one, instructions);
            instructions.add(factory.STORE(env.getNextReilAddress(), addr, t));
        } else {
            LowLevelRReilOpnd src = opnd.getOperandStack().pop();
            LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, src.size());
            LowLevelRReilOpnd one = factory.immediate(src.size(), (Number)1);
            instructions.add(factory.SUB(env.getNextReilAddress(), t, src, one));
            emitter.emit(env, t, src, one, instructions);
            X86Helpers.emitWritebackAndMaybeZeroExtend(env, src, t, instructions);
        }
    }
}

