/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.x86.common.X86Helpers;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;
import rreil.lang.lowlevel.OperandSize;

public class CdqTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        LowLevelRReilOpnd eax = registerTranslator.translateRegister("eax");
        LowLevelRReilOpnd edx = registerTranslator.translateRegister("edx");
        LowLevelRReilOpnd t = registerTranslator.temporaryRegister(env, OperandSize.QWORD);
        instructions.add(factory.SIGNEXTEND(env.getNextReilAddress(), t, eax));
        X86Helpers.emitWritebackAndMaybeZeroExtend(env, edx, t.withOffset(32, OperandSize.DWORD.getBits()), instructions);
    }
}

