/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.x86.common;

import java.util.Arrays;
import java.util.List;
import rreil.disassembler.Instruction;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.InsnTranslator;
import rreil.disassembler.translators.common.RegisterTranslator;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.disassembler.translators.common.TranslationState;
import rreil.disassembler.translators.x86.common.X86OperandTranslator;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class CallTranslator
implements InsnTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    @Override
    public void translate(TranslationCtx env, Instruction instruction, List<LowLevelRReil> instructions) {
        RegisterTranslator registerTranslator = env.getRegisterTranslator();
        List<OperandTree> operands = instruction.operands();
        OperandTree targetOperand = operands.get(0);
        TranslationState opnd = X86OperandTranslator.translateOperand(env, targetOperand);
        LowLevelRReilOpnd target = opnd.getOperandStack().pop();
        LowLevelRReilOpnd sp = registerTranslator.translateRegister("esp").withSize(env.getDefaultArchitectureSize());
        LowLevelRReilOpnd retAddr = factory.immediate(sp.size(), (Number)env.getFollowupAddress(instruction));
        long inc = sp.size() / 8;
        instructions.addAll(opnd.getInstructionStack());
        instructions.addAll(Arrays.asList(factory.SUB(env.getNextReilAddress(), sp, sp, factory.immediate(sp.size(), (Number)inc)), factory.STORE(env.getNextReilAddress(), sp, retAddr), factory.CALL(env.getNextReilAddress(), target)));
    }
}

