/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler.translators.avr8.translators;

import java.util.List;
import rreil.disassembler.translators.avr8.common.AVR8Helpers;
import rreil.disassembler.translators.avr8.common.AVR8OperationTranslator;
import rreil.disassembler.translators.avr8.emitters.GenericFlagEmitter;
import rreil.disassembler.translators.common.InsnEmitter;
import rreil.disassembler.translators.common.TranslationCtx;
import rreil.lang.lowlevel.LowLevelRReil;
import rreil.lang.lowlevel.LowLevelRReilFactory;
import rreil.lang.lowlevel.LowLevelRReilOpnd;

public class LsrTranslator
extends AVR8OperationTranslator {
    private static LowLevelRReilFactory factory = LowLevelRReilFactory.getInstance();

    public LsrTranslator() {
        super(AVR8OperationTranslator.ReturnType.Register);
    }

    @Override
    public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
        instructions.add(factory.SHRS(env.getNextReilAddress(), dst, src1, factory.immediate(dst.size(), (Number)1)));
        LsrFlagEmitter.$.emit(env, dst, src1, src2, instructions);
    }

    public static class LsrFlagEmitter
    implements InsnEmitter {
        public static InsnEmitter $ = new LsrFlagEmitter();

        @Override
        public void emit(TranslationCtx env, LowLevelRReilOpnd dst, LowLevelRReilOpnd src1, LowLevelRReilOpnd src2, List<LowLevelRReil> instructions) {
            instructions.add(factory.CMPEQ(env.getNextReilAddress(), AVR8Helpers.Z_OPERAND, dst, factory.immediate(dst.size(), (Number)0)));
            instructions.add(factory.MOV(env.getNextReilAddress(), AVR8Helpers.N_OPERAND, factory.immediate(dst.size(), (Number)0)));
            instructions.add(factory.MOV(env.getNextReilAddress(), AVR8Helpers.C_OPERAND, src1.withOffset(0, 1)));
            instructions.add(factory.XOR(env.getNextReilAddress(), AVR8Helpers.V_OPERAND, AVR8Helpers.N_OPERAND, AVR8Helpers.C_OPERAND));
            GenericFlagEmitter.$.emit(env, dst, src1, src2, instructions);
        }
    }
}

