/*
 * Decompiled with CFR 0.152.
 */
package rreil.disassembler;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import rreil.disassembler.OpcodeFormatter;
import rreil.disassembler.OperandTree;
import rreil.disassembler.translators.common.TranslationException;
import rreil.lang.RReilAddr;
import rreil.lang.lowlevel.LowLevelRReil;

public abstract class Instruction {
    private final RReilAddr address;
    private final String mnemonic;
    private final List<OperandTree> opnds;
    private final byte[] opcode;

    protected Instruction(long address, byte[] opcode, String mnemonic, List<OperandTree> opnds) {
        this(RReilAddr.valueOf(address), opcode, mnemonic, opnds);
    }

    protected Instruction(RReilAddr address, byte[] opcode, String mnemonic, OperandTree ... opnds) {
        this(address, opcode, mnemonic, Arrays.asList(opnds));
    }

    protected Instruction(RReilAddr address, byte[] opcode, String mnemonic, List<OperandTree> opnds) {
        this.opcode = opcode;
        this.mnemonic = mnemonic;
        this.opnds = Collections.unmodifiableList(opnds);
        this.address = address;
    }

    public String mnemonic() {
        return this.mnemonic;
    }

    public List<OperandTree> operands() {
        return this.opnds;
    }

    public OperandTree operand(int i) {
        return this.opnds.get(i);
    }

    public String toString() {
        StringBuilder pretty = new StringBuilder("{");
        pretty.append(this.address).append(": ");
        this.asString(pretty);
        return pretty.append('}').toString();
    }

    public StringBuilder opcode(StringBuilder buf) {
        return OpcodeFormatter.format(this.opcode, buf);
    }

    public StringBuilder asString(StringBuilder buf) {
        buf.append(this.mnemonic).append(' ');
        for (OperandTree t : this.opnds) {
            t.getRoot().asString(buf).append(' ');
        }
        return buf;
    }

    public int length() {
        return this.opcode.length;
    }

    public byte[] opcode() {
        byte[] data = new byte[this.opcode.length];
        System.arraycopy(this.opcode, 0, data, 0, this.opcode.length);
        return data;
    }

    public long baseAddress() {
        return this.address.base();
    }

    public RReilAddr address() {
        return this.address;
    }

    public abstract List<LowLevelRReil> toRReilInstructions() throws TranslationException;

    public static class InstructionBuilder {
        private final InstructionFactory instructionFactory;
        private final List<OperandTree> operands = new LinkedList<OperandTree>();
        private byte[] opcode = new byte[0];
        private String mnemonic;
        private long address;

        public InstructionBuilder(InstructionFactory factory) {
            this.instructionFactory = factory;
        }

        public InstructionBuilder address(long address) {
            this.address = address;
            return this;
        }

        public InstructionBuilder mnemonic(String mnemonic) {
            this.mnemonic = mnemonic;
            return this;
        }

        public InstructionBuilder opcode(byte[] opcode) {
            this.opcode = opcode;
            return this;
        }

        public InstructionBuilder opcode() {
            this.opcode = new byte[0];
            return this;
        }

        public InstructionBuilder link(OperandTree opnd) {
            this.operands.add(opnd);
            return this;
        }

        public InstructionBuilder link(List<OperandTree> opnds) {
            this.operands.addAll(opnds);
            return this;
        }

        public Instruction build() {
            assert (this.mnemonic != null) : "Null mnemonic";
            assert (this.opcode != null) : "Invalid instruction length";
            return this.instructionFactory.build(this.address, this.opcode, this.mnemonic, this.operands);
        }

        public String toString() {
            return "InstructionBuilder{address=" + this.address + ", opcode=" + this.opcode + ", mnemonic=" + this.mnemonic + ", operands=" + this.operands + '}';
        }
    }

    public static interface InstructionFactory {
        public Instruction build(long var1, byte[] var3, String var4, List<OperandTree> var5);
    }
}

