/*
 * Decompiled with CFR 0.152.
 */
package rreil.assembler;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javalx.numeric.BigInt;
import rreil.assembler.AbstractParseTreeTranslator;
import rreil.assembler.LabelCollector;
import rreil.assembler.parser.ASTCallNat;
import rreil.assembler.parser.ASTFunArgs;
import rreil.assembler.parser.ASTIdent;
import rreil.assembler.parser.ASTLabel;
import rreil.assembler.parser.ASTLabelDeref;
import rreil.assembler.parser.ASTModule;
import rreil.assembler.parser.ASTNatDef;
import rreil.assembler.parser.ASTNatLabel;
import rreil.assembler.parser.ASTNatSizeParam;
import rreil.assembler.parser.ASTNatSizeParams;
import rreil.assembler.parser.ASTOpt;
import rreil.assembler.parser.ASTOptID;
import rreil.assembler.parser.ASTOptVal;
import rreil.assembler.parser.ASTSize;
import rreil.assembler.parser.ASTVariable;
import rreil.assembler.parser.ParseException;
import rreil.assembler.parser.VarSize;
import rreil.lang.RReil;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class SingleFunctionParser
extends AbstractParseTreeTranslator {
    public static final String FUNCTION_LOCALS_PREFIX = "__local__";
    private final List<SizedVariable> inputVars;
    private final List<SizedVariable> outputVars;
    private final Map<String, Integer> sizeParams;
    private LabelCollector labelCollector = null;
    private String name = "<noname_native>";
    private final Map<String, Argument> varsToReplace = new HashMap<String, Argument>();
    private final Map<String, Integer> sizeTemplateParams = new HashMap<String, Integer>();

    public SingleFunctionParser(List<SizedVariable> inputVars, List<SizedVariable> outputVars, Map<String, Integer> sizeParams) {
        this.inputVars = inputVars;
        this.outputVars = outputVars;
        if (sizeParams == null) {
            this.sizeParams = Collections.emptyMap();
        } else {
            this.sizeParams = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : sizeParams.entrySet()) {
                assert (entry.getValue() > 0) : "Sizes must be >= 0!";
                this.sizeParams.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public SortedMap<RReilAddr, RReil> instantiateFunctionTemplate(ASTModule module) throws ParseException {
        this.labelCollector = new LabelCollector();
        module.jjtAccept(this.labelCollector, null);
        module.jjtAccept(this, null);
        return this.instructions;
    }

    @Override
    public Object visit(ASTNatDef node, Object data) throws ParseException {
        int i;
        Argument inArg;
        ASTNatSizeParams sizeParamsNode = (ASTNatSizeParams)node.jjtGetChild(2);
        for (int i2 = 0; i2 < sizeParamsNode.jjtGetNumChildren(); ++i2) {
            ASTNatSizeParam sizeParamNode = (ASTNatSizeParam)sizeParamsNode.jjtGetChild(i2);
            String paramImage = (String)sizeParamNode.jjtGetValue();
            Integer templateSize = this.sizeParams.get(paramImage);
            if (templateSize == null) {
                throw new ParseException("No template size set for '" + paramImage + "'!");
            }
            this.sizeTemplateParams.put(paramImage, templateSize);
        }
        ASTFunArgs inArgs = (ASTFunArgs)node.jjtGetChild(3);
        for (int i3 = 0; i3 < inArgs.jjtGetNumChildren(); i3 += 2) {
            int parsedSize = this.size((ASTSize)inArgs.jjtGetChild(i3 + 1));
            ASTVariable variable = (ASTVariable)inArgs.jjtGetChild(i3);
            String templateId = SingleFunctionParser.identifier((ASTIdent)variable.jjtGetChild(0));
            int inIndex = i3 / 2;
            if (inIndex >= this.inputVars.size()) {
                throw new ParseException("Error while instantiating template function: Expecting more input parameters then available!");
            }
            SizedVariable mappedVar = this.inputVars.get(inIndex);
            if (parsedSize != mappedVar.getSize()) {
                throw new ParseException("Function definitions parameter size does not match given variable size!");
            }
            Argument arg = this.varsToReplace.get(templateId);
            if (arg != null) {
                throw new ParseException("Double occurence of input parameter '" + templateId + "'!");
            }
            inArg = new Argument(mappedVar, Argument.Type.IN);
            this.varsToReplace.put(templateId, inArg);
        }
        ASTFunArgs outArgs = (ASTFunArgs)node.jjtGetChild(0);
        for (i = 0; i < outArgs.jjtGetNumChildren(); i += 2) {
            int parsedSize = this.size((ASTSize)outArgs.jjtGetChild(i + 1));
            ASTVariable variable = (ASTVariable)outArgs.jjtGetChild(i);
            String templateId = SingleFunctionParser.identifier((ASTIdent)variable.jjtGetChild(0));
            int outIndex = i / 2;
            if (outIndex >= this.outputVars.size()) {
                throw new ParseException("Error while instantiating template function: Expecting more output parameters then available!");
            }
            SizedVariable mappedVar = this.outputVars.get(outIndex);
            if (parsedSize != mappedVar.getSize()) {
                throw new ParseException("Function definitions parameter size does not match given variable size!");
            }
            inArg = this.varsToReplace.remove(templateId);
            if (inArg != null) {
                if (inArg.getType() == Argument.Type.OUT) {
                    throw new ParseException("Double occurence of output parameter '" + templateId + "'!");
                }
                if (!mappedVar.getSize().equals(inArg.getSize())) {
                    throw new ParseException("Size of argument '" + mappedVar.getName() + "' differs between in (" + inArg.getSize() + ") and out (" + mappedVar.getSize() + ")!");
                }
                this.varsToReplace.put(templateId, new Argument(inArg, Argument.Type.INOUT));
                continue;
            }
            this.varsToReplace.put(templateId, new Argument(mappedVar, Argument.Type.OUT));
        }
        this.name = ((ASTNatLabel)node.jjtGetChild(1)).jjtGetValue().toString();
        for (i = 4; i < node.jjtGetNumChildren(); ++i) {
            node.jjtGetChild(i).jjtAccept(this, data);
        }
        return null;
    }

    @Override
    public Object visit(ASTNatSizeParams node, Object data) throws ParseException {
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTNatSizeParam node, Object data) throws ParseException {
        return null;
    }

    @Override
    protected Rhs.Rvar variable(ASTVariable node, Integer size) throws ParseException {
        String templateId = SingleFunctionParser.identifier((ASTIdent)node.jjtGetChild(0));
        String instantiatedId = this.checkAndAdjustName(templateId);
        return this.variableWithId(instantiatedId, node, size);
    }

    @Override
    protected Integer size(ASTSize node) throws ParseException {
        VarSize size = (VarSize)node.jjtGetValue();
        if (!size.isSet()) {
            throw new ParseException("In function definitions all sizes must be set explicitly!");
        }
        if (size.isTemlateVar()) {
            String image = size.getToken().image;
            Integer templateSize = this.sizeTemplateParams.get(image);
            if (templateSize == null) {
                throw new ParseException("No template parameter '" + image + "' defined!");
            }
            return templateSize;
        }
        return size.asInteger();
    }

    private String checkAndAdjustName(String templateId) {
        String result = this.varsToReplace.containsKey(templateId) ? this.varsToReplace.get(templateId).getName() : FUNCTION_LOCALS_PREFIX + templateId;
        return result;
    }

    @Override
    public Object visit(ASTFunArgs node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTNatLabel node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTOpt node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTLabelDeref node, Object data) throws ParseException {
        return this.label((ASTLabel)node.jjtGetChild(0), (Integer)data);
    }

    private Rhs.Rlit label(ASTLabel node, Integer size) {
        String name = (String)node.jjtGetValue();
        BigInt labelAddress = BigInt.of(this.labelCollector.getLabelAddress(name).base());
        return rreil.literal(size, labelAddress);
    }

    @Override
    public Object visit(ASTOptID node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTOptVal node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTCallNat node, Object data) throws ParseException {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static class Argument
    extends SizedVariable {
        private final Type type;
        private boolean isWrittenTo = false;
        private boolean isReadFrom = false;

        public Argument(String name, Integer size, Type type) {
            super(name, size);
            this.type = type;
        }

        public Argument(SizedVariable var, Type type) {
            super(var.getName(), var.getSize());
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isWrittenTo() {
            return this.isWrittenTo;
        }

        public boolean isReadFrom() {
            return this.isReadFrom;
        }

        public boolean isUsed() {
            return this.isWrittenTo || this.isReadFrom;
        }

        public void setReadFrom() throws ParseException {
            switch (this.type) {
                case OUT: {
                    throw new ParseException("OUT parameter " + this.getName() + " is read from!");
                }
                case IN: 
                case INOUT: {
                    this.isReadFrom = true;
                }
            }
        }

        public void setWrittenTo() throws ParseException {
            switch (this.type) {
                case IN: {
                    throw new ParseException("IN parameter " + this.getName() + " is read from!");
                }
                case OUT: 
                case INOUT: {
                    this.isWrittenTo = true;
                }
            }
        }

        public static enum Type {
            IN,
            OUT,
            INOUT;

        }
    }

    public static class SizedVariable {
        final String a;
        final Integer b;

        public SizedVariable(String a, Integer b) {
            this.a = a;
            this.b = b;
            assert (b > 0) : "Size must be >= 0!";
        }

        public String getName() {
            return this.a;
        }

        public Integer getSize() {
            return this.b;
        }
    }
}

