/*
 * Decompiled with CFR 0.152.
 */
package rreil.assembler;

import java.util.HashMap;
import java.util.Map;
import javalx.numeric.BigInt;
import javalx.persistentcollections.BiMap;
import rreil.assembler.AbstractParseTreeTranslator;
import rreil.assembler.CompiledAssembler;
import rreil.assembler.LabelCollector;
import rreil.assembler.parser.ASTCallNat;
import rreil.assembler.parser.ASTFunArgs;
import rreil.assembler.parser.ASTLabel;
import rreil.assembler.parser.ASTLabelDeref;
import rreil.assembler.parser.ASTModule;
import rreil.assembler.parser.ASTNatDef;
import rreil.assembler.parser.ASTNatLabel;
import rreil.assembler.parser.ASTNatSizeParam;
import rreil.assembler.parser.ASTNatSizeParams;
import rreil.assembler.parser.ASTOpt;
import rreil.assembler.parser.ASTOptID;
import rreil.assembler.parser.ASTOptVal;
import rreil.assembler.parser.ASTSize;
import rreil.assembler.parser.ParseException;
import rreil.assembler.parser.VarSize;
import rreil.lang.RReilAddr;
import rreil.lang.Rhs;

public class ParseTreeTranslator
extends AbstractParseTreeTranslator {
    private LabelCollector labelCollector;
    private final Map<String, String> options = new HashMap<String, String>();
    private static final String OPT_DEFAULT_SIZE = "DEFAULT_SIZE";

    public CompiledAssembler translate(ASTModule module) throws ParseException {
        this.labelCollector = new LabelCollector();
        module.jjtAccept(this.labelCollector, null);
        module.jjtAccept(this, null);
        BiMap<RReilAddr, String> labels = BiMap.from(this.labelCollector.getLabels()).inverted();
        int defaultSize = 32;
        String defaultSizeOption = this.options.get(OPT_DEFAULT_SIZE);
        if (defaultSizeOption != null) {
            defaultSize = ParseTreeTranslator.parseSizeOption(defaultSizeOption);
        }
        return new CompiledAssembler(this.instructions, this.pointers, labels, defaultSize);
    }

    @Override
    public Object visit(ASTOpt node, Object data) throws ParseException {
        ASTOptID optId = (ASTOptID)node.jjtGetChild(0);
        String id = optId.jjtGetValue().toString();
        ASTOptVal optValue = (ASTOptVal)node.jjtGetChild(1);
        Object value = optValue.jjtGetValue();
        this.options.put(id, value.toString());
        return null;
    }

    @Override
    public Object visit(ASTOptID node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTOptVal node, Object data) throws ParseException {
        return null;
    }

    @Override
    public Object visit(ASTLabelDeref node, Object data) throws ParseException {
        return this.label((ASTLabel)node.jjtGetChild(0), (Integer)data);
    }

    @Override
    public Object visit(ASTCallNat node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Natives not supported!");
    }

    @Override
    public Object visit(ASTNatDef node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Native definitions not supported!");
    }

    @Override
    public Object visit(ASTNatSizeParams node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Native definitions not supported!");
    }

    @Override
    public Object visit(ASTNatSizeParam node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Native definitions not supported!");
    }

    @Override
    public Object visit(ASTNatLabel node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Natives not supported!");
    }

    @Override
    public Object visit(ASTFunArgs node, Object data) throws ParseException {
        throw new UnsupportedOperationException("Natives not supported!");
    }

    @Override
    protected Integer size(ASTSize node) throws ParseException {
        VarSize size = (VarSize)node.jjtGetValue();
        if (!size.isSet()) {
            String optSize = this.options.get(OPT_DEFAULT_SIZE);
            if (optSize == null) {
                throw new ParseException("No size defined, while option DEFAULT_SIZE is not set, either! Near: " + this.currentInstructionAddress);
            }
            Integer defaultSize = ParseTreeTranslator.parseSizeOption(optSize.toString());
            return defaultSize;
        }
        if (size.isTemlateVar()) {
            throw new ParseException("No size templates allowed outside function definitions!");
        }
        return size.asInteger();
    }

    private static Integer parseSizeOption(String sizeStr) throws ParseException {
        if (sizeStr.isEmpty()) {
            throw new ParseException("Option DEFAULT_SIZE filled with undefined content: '" + sizeStr + "'!");
        }
        if (sizeStr.length() != 1) {
            return Integer.valueOf(sizeStr);
        }
        switch (sizeStr.charAt(0)) {
            case '1': {
                return 1;
            }
            case 'b': {
                return 8;
            }
            case 'w': {
                return 16;
            }
            case 'd': {
                return 32;
            }
            case 'q': {
                return 64;
            }
            case 'o': {
                return 128;
            }
            case 'z': {
                return 256;
            }
        }
        return Integer.valueOf(sizeStr);
    }

    private Rhs.Rlit label(ASTLabel node, Integer size) throws ParseException {
        String name = (String)node.jjtGetValue();
        RReilAddr rreilAddr = this.labelCollector.getLabelAddress(name);
        if (rreilAddr == null) {
            throw new ParseException("Undefined label: " + name);
        }
        BigInt labelAddress = BigInt.of(rreilAddr.base());
        return rreil.literal(size, labelAddress);
    }
}

