/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public final class LubyRestarts
implements RestartStrategy {
    private static final int DEFAULT_LUBY_FACTOR = 32;
    private static final int PRECOMPUTED_VALUES_IN_POOL = 32;
    private static final long serialVersionUID = 1L;
    private static int[] cachedValues;
    private int factor;
    private int count;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 1;
        nArray[3] = 2;
        cachedValues = nArray;
        LubyRestarts.luby(32);
    }

    public static final int luby(int i) {
        if (i >= 0x3FFFFFFF) {
            throw new IllegalArgumentException("i is too big");
        }
        if (i >= cachedValues.length) {
            int oldsize = cachedValues.length;
            int newsize = i << 1;
            int[] newContent = new int[newsize + 1];
            System.arraycopy(cachedValues, 0, newContent, 0, oldsize);
            int nextPowerOfTwo = 1;
            while (nextPowerOfTwo <= oldsize) {
                nextPowerOfTwo <<= 1;
            }
            int lastPowerOfTwo = nextPowerOfTwo >> 1;
            int j = oldsize;
            while (j <= newsize) {
                if (j + 1 == nextPowerOfTwo) {
                    newContent[j] = lastPowerOfTwo;
                    lastPowerOfTwo = nextPowerOfTwo;
                    nextPowerOfTwo <<= 1;
                } else {
                    newContent[j] = newContent[j - lastPowerOfTwo + 1];
                }
                ++j;
            }
            cachedValues = newContent;
        }
        return cachedValues[i];
    }

    public LubyRestarts() {
        this(32);
    }

    public LubyRestarts(int factor) {
        this.setFactor(factor);
    }

    public final void setFactor(int factor) {
        this.factor = factor;
    }

    public int getFactor() {
        return this.factor;
    }

    public void init(SearchParams params) {
        this.count = 1;
    }

    public long nextRestartNumberOfConflict() {
        return LubyRestarts.luby(this.count) * this.factor;
    }

    public void onRestart() {
        ++this.count;
    }

    public String toString() {
        return "luby style (SATZ_rand, TiniSAT) restarts strategy with factor " + this.factor;
    }
}

