/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import org.eclipse.cdt.utils.elf.Elf;

public class ElfHelper {
    private Elf elf;
    private Elf.Symbol[] dynsyms;
    private Elf.Symbol[] symbols;
    private Elf.Section[] sections;
    private Elf.Dynamic[] dynamics;

    public void dispose() {
        if (this.elf != null) {
            this.elf.dispose();
            this.elf = null;
        }
    }

    private void loadSymbols() throws IOException {
        if (this.symbols == null) {
            this.elf.loadSymbols();
            this.symbols = this.elf.getSymtabSymbols();
            this.dynsyms = this.elf.getDynamicSymbols();
            if (this.symbols.length <= 0) {
                this.symbols = this.dynsyms;
            }
            if (this.dynsyms.length <= 0) {
                this.dynsyms = this.symbols;
            }
        }
    }

    private void loadSections() throws IOException {
        if (this.sections == null) {
            this.sections = this.elf.getSections();
        }
    }

    private void loadDynamics() throws IOException {
        if (this.dynamics == null) {
            this.dynamics = new Elf.Dynamic[0];
            Elf.Section dynSect = this.elf.getSectionByName(".dynamic");
            if (dynSect != null) {
                this.dynamics = this.elf.getDynamicSections(dynSect);
            }
        }
    }

    public ElfHelper(Elf elf) throws IOException {
        this.elf = elf;
    }

    public ElfHelper(String filename) throws IOException {
        this.elf = new Elf(filename);
    }

    public ElfHelper(String filename, long fileoffset) throws IOException {
        this.elf = new Elf(filename, fileoffset);
    }

    public Elf getElf() {
        return this.elf;
    }

    public Elf.Symbol[] getExternalFunctions() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        for (int i = 0; i < this.dynsyms.length; ++i) {
            if (this.dynsyms[i].st_bind() != 1 || this.dynsyms[i].st_type() != 2) continue;
            short idx = this.dynsyms[i].st_shndx;
            if (idx < -225 && idx > -256) {
                String name = this.dynsyms[i].toString();
                if (name == null || name.trim().length() <= 0) continue;
                v.add(this.dynsyms[i]);
                continue;
            }
            if (idx < 0 || this.sections[idx].sh_type != 0L) continue;
            v.add(this.dynsyms[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Symbol[] getExternalObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        for (int i = 0; i < this.dynsyms.length; ++i) {
            if (this.dynsyms[i].st_bind() != 1 || this.dynsyms[i].st_type() != 1) continue;
            short idx = this.dynsyms[i].st_shndx;
            if (idx < -225 && idx > -256) {
                String name = this.dynsyms[i].toString();
                if (name == null || name.trim().length() <= 0) continue;
                v.add(this.dynsyms[i]);
                continue;
            }
            if (idx < 0 || this.sections[idx].sh_type != 0L) continue;
            v.add(this.dynsyms[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Symbol[] getUndefined() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        for (int i = 0; i < this.dynsyms.length; ++i) {
            if (this.dynsyms[i].st_shndx != 0) continue;
            v.add(this.dynsyms[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Symbol[] getLocalFunctions() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (this.symbols[i].st_type() != 2) continue;
            short idx = this.symbols[i].st_shndx;
            if (idx < -225 && idx > -256) {
                String name = this.symbols[i].toString();
                if (name == null || name.trim().length() <= 0) continue;
                v.add(this.symbols[i]);
                continue;
            }
            if (idx < 0 || this.sections[idx].sh_type == 0L) continue;
            v.add(this.symbols[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Symbol[] getLocalObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        for (int i = 0; i < this.symbols.length; ++i) {
            if (this.symbols[i].st_type() != 1) continue;
            short idx = this.symbols[i].st_shndx;
            if (idx < -225 && idx > -256) {
                String name = this.symbols[i].toString();
                if (name == null || name.trim().length() <= 0) continue;
                v.add(this.symbols[i]);
                continue;
            }
            if (idx < 0 || this.sections[idx].sh_type == 0L) continue;
            v.add(this.symbols[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Symbol[] getCommonObjects() throws IOException {
        Vector<Elf.Symbol> v = new Vector<Elf.Symbol>();
        this.loadSymbols();
        this.loadSections();
        for (int i = 0; i < this.symbols.length; ++i) {
            short idx;
            if (this.symbols[i].st_bind() != 1 || this.symbols[i].st_type() != 1 || (idx = this.symbols[i].st_shndx) != -14) continue;
            v.add(this.symbols[i]);
        }
        Elf.Symbol[] ret = v.toArray(new Elf.Symbol[v.size()]);
        return ret;
    }

    public Elf.Dynamic[] getNeeded() throws IOException {
        Vector<Elf.Dynamic> v = new Vector<Elf.Dynamic>();
        this.loadDynamics();
        for (int i = 0; i < this.dynamics.length; ++i) {
            if (this.dynamics[i].d_tag != 1L) continue;
            v.add(this.dynamics[i]);
        }
        return v.toArray(new Elf.Dynamic[v.size()]);
    }

    public String getSoname() throws IOException {
        String soname = "";
        this.loadDynamics();
        for (int i = 0; i < this.dynamics.length; ++i) {
            if (this.dynamics[i].d_tag != 14L) continue;
            soname = this.dynamics[i].toString();
        }
        return soname;
    }

    private String getSubUsage(String full, String name) {
        int start = 0;
        int end = 0;
        for (int i = 0; i < full.length(); ++i) {
            if (full.charAt(i) != '%' || full.charAt(i + 1) != '-') continue;
            if (start == 0) {
                int eol = full.indexOf(10, i + 2);
                String temp = full.substring(i + 2, eol);
                if (temp.compareTo(name) != 0) continue;
                start = eol;
                continue;
            }
            if (end != 0) continue;
            end = i - 1;
        }
        if (end == 0) {
            end = full.length();
        }
        if (start == 0) {
            return full;
        }
        return full.substring(start, end);
    }

    public String getQnxUsage() throws IOException {
        this.loadSections();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].toString().compareTo("QNX_usage") != 0) continue;
            File file = new File(this.elf.getFilename());
            String full_usage = new String(this.sections[i].loadSectionData());
            String usage = this.getSubUsage(full_usage, file.getName());
            StringBuffer buffer = new StringBuffer(usage);
            for (int j = 0; j < buffer.length(); ++j) {
                if (buffer.charAt(j) != '%' || buffer.charAt(j + 1) != 'C') continue;
                buffer.replace(j, j + 2, file.getName());
            }
            return buffer.toString();
        }
        return new String("");
    }

    public Sizes getSizes() throws IOException {
        long text = 0L;
        long data = 0L;
        long bss = 0L;
        this.loadSections();
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.sections[i].sh_type != 8L) {
                if (this.sections[i].sh_flags == 3L) {
                    data += this.sections[i].sh_size;
                    continue;
                }
                if ((this.sections[i].sh_flags & 2L) == 0L) continue;
                text += this.sections[i].sh_size;
                continue;
            }
            if (this.sections[i].sh_flags != 3L) continue;
            bss += this.sections[i].sh_size;
        }
        return new Sizes(text, data, bss);
    }

    public class Sizes {
        public long text;
        public long data;
        public long bss;
        public long total;

        public Sizes(long t, long d, long b) {
            this.text = t;
            this.data = d;
            this.bss = b;
            this.total = this.text + this.data + this.bss;
        }
    }
}

