/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.IOException;

public class ByteUtils {
    public static short makeShort(byte[] bytes, int offset, boolean isle) throws IOException {
        if (bytes.length < offset + 2) {
            throw new IOException();
        }
        return isle ? (short)(bytes[offset + 1] << 8 | bytes[offset + 0] & 0xFF) : (short)(bytes[offset + 0] << 8 | bytes[offset + 1] & 0xFF);
    }

    public static long makeInt(byte[] bytes, int offset, boolean isle) throws IOException {
        if (bytes.length < offset + 4) {
            throw new IOException();
        }
        return isle ? (long)((bytes[offset + 3] << 24) + ((bytes[offset + 2] & 0xFF) << 16) + ((bytes[offset + 1] & 0xFF) << 8) + (bytes[offset + 0] & 0xFF)) : (long)((bytes[offset + 0] << 24) + ((bytes[offset + 1] & 0xFF) << 16) + ((bytes[offset + 2] & 0xFF) << 8) + (bytes[offset + 3] & 0xFF));
    }

    public static long makeLong(byte[] bytes, int offset, boolean isle) throws IOException {
        long result = 0L;
        int shift = 0;
        if (isle) {
            for (int i = 7; i >= 0; --i) {
                shift = i * 8;
                result += (long)bytes[offset + i] << shift & 255L << shift;
            }
        } else {
            for (int i = 0; i <= 7; ++i) {
                shift = (7 - i) * 8;
                result += (long)bytes[offset + i] << shift & 255L << shift;
            }
        }
        return result;
    }
}

