/*
 * Decompiled with CFR 0.152.
 */
package javalx.persistentcollections.tree;

import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import javalx.data.Option;
import javalx.data.products.P2;
import javalx.fn.Fn;
import javalx.fn.Fn2;
import javalx.persistentcollections.ThreeWaySplit;
import javalx.persistentcollections.tree.ExtendedTree;
import javalx.persistentcollections.tree.Tree;

public final class AVLTree<K, V>
implements ExtendedTree<K, V, AVLTree<K, V>> {
    private static final int WEIGHT = 3;
    private final AVLTree<K, V> left;
    private final AVLTree<K, V> right;
    private final Entry<K, V> entry;
    private final int size;

    public static <K, V> AVLTree<K, V> empty() {
        return new AVLTree<K, V>(null, 0, null, null);
    }

    private static <K, V> AVLTree<K, V> node(Entry<K, V> entry, AVLTree<K, V> left, AVLTree<K, V> right) {
        return new AVLTree<K, V>(entry, left.size + right.size + 1, left, right);
    }

    private AVLTree(Entry<K, V> entry, int size, AVLTree<K, V> left, AVLTree<K, V> right) {
        this.left = left;
        this.right = right;
        this.entry = entry;
        this.size = size;
    }

    @Override
    public final Option<V> get(K key) {
        if (this.isEmpty()) {
            return Option.none();
        }
        int compareTo = ((Comparable)key).compareTo(this.entry.getKey());
        if (compareTo < 0) {
            return this.left.get(key);
        }
        if (compareTo > 0) {
            return this.right.get(key);
        }
        return Option.some(this.entry.getValue());
    }

    @Override
    public final V getOrNull(K key) {
        if (this.isEmpty()) {
            return null;
        }
        int compareTo = ((Comparable)key).compareTo(this.entry.getKey());
        if (compareTo < 0) {
            return this.left.getOrNull(key);
        }
        if (compareTo > 0) {
            return this.right.getOrNull(key);
        }
        return this.entry.getValue();
    }

    @Override
    public final AVLTree<K, V> bind(K key, V value) {
        assert (value != null);
        return this.bind(new Entry<K, V>(key, value));
    }

    private final AVLTree<K, V> bind(Entry<K, V> e) {
        Comparable eComparable = (Comparable)e.getKey();
        if (this.isEmpty()) {
            return AVLTree.node(e, this, this);
        }
        int compareTo = eComparable.compareTo(this.entry.getKey());
        if (compareTo < 0) {
            return AVLTree.balance(this.entry, super.bind(e), this.right);
        }
        if (compareTo > 0) {
            return AVLTree.balance(this.entry, this.left, super.bind(e));
        }
        return AVLTree.node(e, this.left, this.right);
    }

    @Override
    public final AVLTree<K, V> remove(K key) {
        if (this.isEmpty()) {
            return this;
        }
        int compareTo = ((Comparable)key).compareTo(this.entry.getKey());
        if (compareTo < 0) {
            return AVLTree.balance(this.entry, this.left.remove((Object)key), this.right);
        }
        if (compareTo > 0) {
            return AVLTree.balance(this.entry, this.left, this.right.remove((Object)key));
        }
        return AVLTree.remove(this.left, this.right);
    }

    private static <K, V> AVLTree<K, V> remove(AVLTree<K, V> left, AVLTree<K, V> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        AVLTree<K, V> min = super.min();
        return AVLTree.balance(min.entry, left, right.removeMin());
    }

    @Override
    public AVLTree<K, V> removeMin() {
        if (this.left.isEmpty()) {
            return this.right;
        }
        return AVLTree.balance(this.entry, this.left.removeMin(), this.right);
    }

    public AVLTree<K, V> removeMinUnbalanced() {
        if (this.left.isEmpty()) {
            return this.right;
        }
        return AVLTree.node(this.entry, this.left.removeMin(), this.right);
    }

    @Override
    public Option<P2<K, V>> getMin() {
        if (this.isEmpty()) {
            return Option.none();
        }
        AVLTree<K, V> min = this.min();
        return Option.some(min.entry);
    }

    private AVLTree<K, V> min() {
        if (this.left.isEmpty()) {
            return this;
        }
        return super.min();
    }

    @Override
    public AVLTree<K, V> removeMax() {
        if (this.right.isEmpty()) {
            return this.left;
        }
        return AVLTree.balance(this.entry, this.left, this.right.removeMax());
    }

    @Override
    public Option<P2<K, V>> getMax() {
        if (this.isEmpty()) {
            return Option.none();
        }
        AVLTree<K, V> max = this.max();
        return Option.some(max.entry);
    }

    private AVLTree<K, V> max() {
        if (this.right.isEmpty()) {
            return this;
        }
        return super.max();
    }

    @Override
    public final int size() {
        return this.size;
    }

    private static <K, V> AVLTree<K, V> join(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        return AVLTree.node(e, left, right);
    }

    private static <K, V> AVLTree<K, V> balance(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        if (Math.abs(left.size - right.size) > 1) {
            if (right.size >= 3 * left.size) {
                if (right.left.size < right.right.size) {
                    return AVLTree.rotateSingleLeft(e, left, right);
                }
                return AVLTree.rotateDoubleLeft(e, left, right);
            }
            if (left.size >= 3 * right.size) {
                if (left.right.size < left.left.size) {
                    return AVLTree.rotateSingleRight(e, left, right);
                }
                return AVLTree.rotateDoubleRight(e, left, right);
            }
            return AVLTree.node(e, left, right);
        }
        return AVLTree.node(e, left, right);
    }

    private static <K, V> AVLTree<K, V> rotateDoubleLeft(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        return AVLTree.join(right.left.entry, AVLTree.join(e, left, right.left.left), AVLTree.join(right.entry, right.left.right, right.right));
    }

    private static <K, V> AVLTree<K, V> rotateDoubleRight(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        return AVLTree.join(left.right.entry, AVLTree.join(left.entry, left.left, left.right.left), AVLTree.join(e, left.right.right, right));
    }

    private static <K, V> AVLTree<K, V> rotateSingleLeft(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        return AVLTree.join(right.entry, AVLTree.join(e, left, right.left), right.right);
    }

    private static <K, V> AVLTree<K, V> rotateSingleRight(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        return AVLTree.join(left.entry, left.left, AVLTree.join(e, left.right, right));
    }

    @Override
    public final AVLTree<K, V> union(AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this == other) {
            return this;
        }
        Tree lowerSubTree = other.splitTail((Object)this.entry.getKey());
        Tree upperSubTree = other.splitHead((Object)this.entry.getKey());
        return AVLTree.concat3(this.entry, this.left.union((AVLTree<K, V>)lowerSubTree), this.right.union((AVLTree<K, V>)upperSubTree));
    }

    @Override
    public final AVLTree<K, V> union(Fn2<V, V, V> selector, AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return other;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this == other) {
            return this;
        }
        Tree lowerSubTree = other.splitTail((Object)this.entry.getKey());
        Tree upperSubTree = other.splitHead((Object)this.entry.getKey());
        Option<V> valueInOther = other.get(this.entry.getKey());
        if (valueInOther.isSome()) {
            V v = selector.apply(this.entry.getValue(), valueInOther.get());
            Entry<K, V> e = new Entry<K, V>(this.entry.getKey(), v);
            return AVLTree.concat3(e, this.left.union(selector, (AVLTree<K, V>)lowerSubTree), this.right.union(selector, (AVLTree<K, V>)upperSubTree));
        }
        return AVLTree.concat3(this.entry, this.left.union(selector, (AVLTree<K, V>)lowerSubTree), this.right.union(selector, (AVLTree<K, V>)upperSubTree));
    }

    @Override
    public final AVLTree<K, V> intersection(AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        if (this == other) {
            return this;
        }
        K otherKey = other.entry.getKey();
        Tree lowerSubTree = this.splitTail((Object)otherKey);
        Tree upperSubTree = this.splitHead((Object)otherKey);
        Option<V> valueInThis = this.get(otherKey);
        if (valueInThis.isSome()) {
            return AVLTree.concat3(new Entry<K, V>(otherKey, valueInThis.get()), ((AVLTree)lowerSubTree).intersection(other.left), ((AVLTree)upperSubTree).intersection(other.right));
        }
        return AVLTree.concat(((AVLTree)lowerSubTree).intersection(other.left), ((AVLTree)upperSubTree).intersection(other.right));
    }

    @Override
    public final AVLTree<K, V> intersection(Fn2<V, V, V> selector, AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        if (this == other) {
            return this;
        }
        Tree lowerSubTree = this.splitTail((Object)other.entry.getKey());
        Tree upperSubTree = this.splitHead((Object)other.entry.getKey());
        Option<V> valueInThis = this.get(other.entry.getKey());
        if (valueInThis.isSome()) {
            V v = selector.apply(valueInThis.get(), other.entry.getValue());
            return AVLTree.concat3(new Entry<K, V>(other.entry.getKey(), v), ((AVLTree)lowerSubTree).intersection(selector, other.left), ((AVLTree)upperSubTree).intersection(selector, other.right));
        }
        return AVLTree.concat(((AVLTree)lowerSubTree).intersection(selector, other.left), ((AVLTree)upperSubTree).intersection(selector, other.right));
    }

    @Override
    public final AVLTree<K, V> difference(AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return this;
        }
        if (this == other) {
            return AVLTree.empty();
        }
        K otherKey = other.entry.getKey();
        Tree lowerSubTree = this.splitTail((Object)otherKey);
        Tree upperSubTree = this.splitHead((Object)otherKey);
        return AVLTree.concat(((AVLTree)lowerSubTree).difference(other.left), ((AVLTree)upperSubTree).difference(other.right));
    }

    private final AVLTree<K, V> intersectionWithNonEqualValues(AVLTree<K, V> other) {
        if (this.isEmpty()) {
            return this;
        }
        if (other.isEmpty()) {
            return other;
        }
        if (this == other) {
            return AVLTree.empty();
        }
        K otherKey = other.entry.getKey();
        Tree lowerSubTree = this.splitTail((Object)otherKey);
        Tree upperSubTree = this.splitHead((Object)otherKey);
        Option<V> valueInThis = this.get(otherKey);
        if (valueInThis.isSome()) {
            V actualValueInOther;
            V actualValueInThis = valueInThis.get();
            if (actualValueInThis == (actualValueInOther = other.entry.getValue()) || actualValueInThis.equals(actualValueInOther)) {
                return AVLTree.concat(super.intersectionWithNonEqualValues(other.left), super.intersectionWithNonEqualValues(other.right));
            }
            return AVLTree.concat3(new Entry<K, V>(otherKey, valueInThis.get()), super.intersectionWithNonEqualValues(other.left), super.intersectionWithNonEqualValues(other.right));
        }
        return AVLTree.concat(super.intersectionWithNonEqualValues(other.left), super.intersectionWithNonEqualValues(other.right));
    }

    @Override
    public final ThreeWaySplit<AVLTree<K, V>> split(AVLTree<K, V> other) {
        AVLTree<K, V> inBoth = this.intersection(other);
        AVLTree<K, V> inBothWithNonEqualValues = this.intersectionWithNonEqualValues(other);
        AVLTree<K, V> onlyInLeft = this.difference(inBoth);
        AVLTree<K, V> onlyInRight = other.difference(inBoth);
        return ThreeWaySplit.make(onlyInLeft, inBothWithNonEqualValues, onlyInRight);
    }

    private static <K, V> AVLTree<K, V> concat3(Entry<K, V> e, AVLTree<K, V> left, AVLTree<K, V> right) {
        if (left.isEmpty()) {
            return super.bind(e);
        }
        if (right.isEmpty()) {
            return super.bind(e);
        }
        if (3 * left.size < right.size) {
            return AVLTree.balance(right.entry, AVLTree.concat3(e, left, right.left), right.right);
        }
        if (3 * right.size < left.size) {
            return AVLTree.balance(left.entry, left.left, AVLTree.concat3(e, left.right, right));
        }
        return AVLTree.join(e, left, right);
    }

    private static <K, V> AVLTree<K, V> concat(AVLTree<K, V> left, AVLTree<K, V> right) {
        if (left.isEmpty()) {
            return right;
        }
        if (right.isEmpty()) {
            return left;
        }
        if (3 * left.size < right.size) {
            return AVLTree.balance(right.entry, AVLTree.concat(left, right.left), right.right);
        }
        if (3 * right.size < left.size) {
            return AVLTree.balance(left.entry, left.left, AVLTree.concat(left.right, right));
        }
        AVLTree<K, V> min = super.min();
        return AVLTree.balance(min.entry, left, right.removeMin());
    }

    @Override
    public final AVLTree<K, V> splitHead(K key) {
        if (this.isEmpty()) {
            return this;
        }
        int compareTo = ((Comparable)this.entry.getKey()).compareTo(key);
        if (compareTo < 0) {
            return this.right.splitHead((Object)key);
        }
        if (compareTo > 0) {
            return AVLTree.concat3(this.entry, this.left.splitHead((Object)key), this.right);
        }
        return this.right;
    }

    @Override
    public final AVLTree<K, V> splitTail(K key) {
        if (this.isEmpty()) {
            return this;
        }
        int compareTo = ((Comparable)key).compareTo(this.entry.getKey());
        if (compareTo < 0) {
            return this.left.splitTail((Object)key);
        }
        if (compareTo > 0) {
            return AVLTree.concat3(this.entry, this.left, this.right.splitTail((Object)key));
        }
        return this.left;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public <R> AVLTree<R, V> mapOnKeys(Fn<K, R> fn) {
        Tree<K, V, AVLTree<K, V>> result = AVLTree.empty();
        for (P2<K, V> pair : this) {
            result = result.bind(fn.apply(pair._1()), (Object)pair._2());
        }
        return result;
    }

    public <R> AVLTree<K, R> mapOnValues(Fn<V, R> fn) {
        Tree<K, V, AVLTree<K, V>> result = AVLTree.empty();
        for (P2<K, V> pair : this) {
            result = result.bind((Object)pair._1(), fn.apply(pair._2()));
        }
        return result;
    }

    @Override
    public final Iterator<P2<K, V>> iterator() {
        return new AVLTreeIterator(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AVLTree)) {
            return false;
        }
        AVLTree other = (AVLTree)obj;
        ThreeWaySplit<AVLTree<K, V>> split = this.split(other);
        return split.inBothButDiffering().isEmpty() && split.onlyInFirst().isEmpty() && split.onlyInSecond().isEmpty();
    }

    public String toString() {
        if (this.size == 0) {
            return "Empty{}";
        }
        return "Node{key=" + this.entry.getKey() + '}';
    }

    public static class Entry<K, V>
    extends P2<K, V>
    implements Map.Entry<K, V> {
        public Entry(K a, V b) {
            super(a, b);
        }

        @Override
        public K getKey() {
            return (K)this._1();
        }

        @Override
        public V getValue() {
            return (V)this._2();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class AVLTreeIterator<K, V>
    implements Iterator<P2<K, V>> {
        Stack<AVLTree<K, V>> stack = new Stack();

        private AVLTreeIterator(AVLTree<K, V> tree) {
            this.push(tree);
        }

        private void push(AVLTree<K, V> tree) {
            while (tree.size > 0) {
                this.stack.push(tree);
                tree = tree.left;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.stack.isEmpty();
        }

        @Override
        public P2<K, V> next() {
            try {
                AVLTree<K, V> curr = this.stack.pop();
                this.push(((AVLTree)curr).right);
                return ((AVLTree)curr).entry;
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported using AVLTree iterators");
        }
    }
}

