/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import javalx.data.ConcatIterator;
import javalx.data.Option;
import javalx.fn.Fn2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;
import javalx.numeric.Interval;

public class IntervalSet
implements Comparable<IntervalSet>,
Iterable<Interval> {
    private final LinkedList<Interval> intervals;
    public static final IntervalSet ZERO = new IntervalSet(Interval.ZERO);
    public static final IntervalSet MINUSONE = new IntervalSet(Interval.MINUSONE);
    public static final IntervalSet TOP = new IntervalSet(Interval.TOP);
    public static final IntervalSet BOOLEANTOP = new IntervalSet(Interval.BOOLEANTOP);
    public static final IntervalSet GREATER_THAN_OR_EQUAL_TO_ZERO = new IntervalSet(Interval.GREATER_THAN_OR_EQUAL_TO_ZERO);
    private static final Comparator<Interval> COMPARATOR_LOWER_BOUND = new Comparator<Interval>(){

        @Override
        public int compare(Interval t1, Interval t2) {
            Bound t1Low = t1.low();
            Bound t2Low = t2.low();
            return t1Low.compareTo(t2Low);
        }
    };
    public static final Fn2<IntervalSet, IntervalSet, IntervalSet> join = new Fn2<IntervalSet, IntervalSet, IntervalSet>(){

        @Override
        public IntervalSet apply(IntervalSet a, IntervalSet b) {
            return a.join(b);
        }
    };
    public static final Fn2<IntervalSet, IntervalSet, IntervalSet> widen = new Fn2<IntervalSet, IntervalSet, IntervalSet>(){

        @Override
        public IntervalSet apply(IntervalSet a, IntervalSet b) {
            return a.widen(b);
        }
    };

    public IntervalSet(Interval ... base) {
        this.intervals = IntervalSet.norm(Arrays.asList(base));
    }

    public IntervalSet(List<Interval> base) {
        this.intervals = IntervalSet.norm(new ArrayList<Interval>(base));
    }

    private static LinkedList<Interval> norm(List<Interval> input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Given list of intervals must not be emtpy!");
        }
        Collections.sort(input, COMPARATOR_LOWER_BOUND);
        Iterator<Interval> it = input.iterator();
        LinkedList<Interval> result = new LinkedList<Interval>();
        Interval prev = it.next();
        result.add(prev);
        while (it.hasNext()) {
            Interval cur = it.next();
            if (prev.contains(cur)) continue;
            if (cur.overlaps(prev) || prev.isAdjacent(cur)) {
                cur = prev.join(cur);
                result.removeLast();
            }
            result.add(cur);
            prev = cur;
        }
        return result;
    }

    public static IntervalSet valueOf(BigInt ... bigInts) {
        ArrayList<Interval> intervals = new ArrayList<Interval>(bigInts.length);
        for (BigInt bigInt : bigInts) {
            Interval boundedInt = Interval.of(bigInt);
            intervals.add(boundedInt);
        }
        return new IntervalSet(intervals);
    }

    public static IntervalSet valueOf(Interval ... intervals) {
        return new IntervalSet(intervals);
    }

    public static IntervalSet valueOf(String str) {
        String[] intervalStrs;
        str = IntervalSet.removeBraces(str);
        LinkedList<Interval> intervalList = new LinkedList<Interval>();
        for (String intervalStr : intervalStrs = str.split(",(?!([\\s]*((\\+|-)?[\\d]+|(\\+oo))\\]))")) {
            intervalStr = intervalStr.trim();
            intervalList.add(Interval.of(intervalStr.trim()));
        }
        return new IntervalSet(intervalList);
    }

    private static String removeBraces(String str) {
        boolean endsWithBrace;
        boolean startsWithBrace = str.startsWith("{");
        if (startsWithBrace != (endsWithBrace = str.endsWith("}"))) {
            throw new NumberFormatException("IntervalSet misses a opening or closing brace!");
        }
        if (startsWithBrace) {
            str = str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static IntervalSet signedTop(int size) {
        return IntervalSet.valueOf(Interval.signedTop(size));
    }

    public static IntervalSet unsignedTop(int size) {
        return IntervalSet.valueOf(Interval.unsignedTop(size));
    }

    @Override
    public int compareTo(IntervalSet other) {
        Iterator<Interval> thisIt = this.iterator();
        Iterator<Interval> otherIt = other.iterator();
        while (thisIt.hasNext() && otherIt.hasNext()) {
            int compResult = COMPARATOR_LOWER_BOUND.compare(thisIt.next(), otherIt.next());
            if (compResult == 0) continue;
            return compResult;
        }
        if (thisIt.hasNext()) {
            return 1;
        }
        if (otherIt.hasNext()) {
            return -1;
        }
        return 0;
    }

    public IntervalSet join(IntervalSet other) {
        ArrayList<Interval> newIntervalsBase = new ArrayList<Interval>(other.intervals.size() + this.intervals.size());
        newIntervalsBase.addAll(other.intervals);
        newIntervalsBase.addAll(this.intervals);
        return new IntervalSet(newIntervalsBase);
    }

    public IntervalSet widen(IntervalSet other) {
        LinkedList<Interval> thisIt = new LinkedList<Interval>(this.intervals);
        LinkedList<Interval> otherIt = new LinkedList<Interval>(other.intervals);
        LinkedList<Interval> result = new LinkedList<Interval>();
        Interval highestInterval = null;
        boolean isFirstIntervalInThis = true;
        while (!thisIt.isEmpty() && !otherIt.isEmpty()) {
            Interval thisCur = (Interval)thisIt.poll();
            Interval otherCur = (Interval)otherIt.peek();
            boolean thisCurIsMeet = false;
            while (otherCur.high().isLessThanOrEqualTo(thisCur.high()) || otherCur.low().isLessThanOrEqualTo(thisCur.high())) {
                if (otherCur.isEqualTo(thisCur)) {
                    thisCurIsMeet |= true;
                } else if (!otherCur.overlaps(thisCur)) {
                    thisCurIsMeet |= false;
                    if (isFirstIntervalInThis) {
                        Interval grownInterval;
                        highestInterval = grownInterval = Interval.downFrom(thisCur.high());
                        result.add(grownInterval);
                    } else {
                        highestInterval = otherCur;
                        result.add(otherCur);
                    }
                } else {
                    Interval widened;
                    Bound hi;
                    int hiMode;
                    thisCurIsMeet |= true;
                    int loMode = otherCur.low().compareTo(thisCur.low());
                    if (Math.abs(loMode + (hiMode = otherCur.high().compareTo(thisCur.high()))) == 2) {
                        throw new IllegalArgumentException("Intervals must not MOVE!");
                    }
                    Bound lo = loMode < 0 ? (highestInterval == null ? Bound.NEGINF : highestInterval.high()) : otherCur.low();
                    if (hiMode > 0) {
                        Interval next;
                        Iterator thisNextIt = thisIt.iterator();
                        Interval thisNext = null;
                        while (thisNextIt.hasNext()) {
                            thisNext = (Interval)thisNextIt.next();
                            if (thisNext.high().isLessThan(otherCur.high())) {
                                thisNextIt.remove();
                                continue;
                            }
                            if (otherCur.high().isEqualTo(thisNext.high())) {
                                thisNextIt.remove();
                                break;
                            }
                            if (!otherCur.high().isLessThan(thisNext.high())) continue;
                        }
                        hi = thisNext != null && thisNext.high().isEqualTo(otherCur.high()) ? otherCur.high() : ((next = (Interval)thisIt.peek()) == null ? Bound.POSINF : next.high());
                    } else {
                        hi = otherCur.high();
                    }
                    if (lo.isEqualTo(Bound.POSINF)) {
                        return new IntervalSet(result);
                    }
                    highestInterval = widened = Interval.of(lo, hi);
                    result.add(widened);
                }
                otherIt.remove();
                if (otherIt.isEmpty()) break;
                otherCur = (Interval)otherIt.peek();
            }
            if (!thisCurIsMeet) {
                throw new IllegalArgumentException("Intervals must not DISAPPEAR!");
            }
            highestInterval = highestInterval == null ? thisCur : (highestInterval.high().isLessThan(thisCur.high()) ? thisCur : highestInterval);
            result.add(thisCur);
            isFirstIntervalInThis = false;
        }
        if (!thisIt.isEmpty()) {
            for (Interval newInterval : thisIt) {
                if (highestInterval.contains(newInterval)) continue;
                throw new IllegalArgumentException("Intervals must not DISAPPEAR!");
            }
        }
        if (!otherIt.isEmpty()) {
            Interval last = (Interval)result.pollLast();
            Interval lastGrown = Interval.of(last.low(), Bound.POSINF);
            result.add(lastGrown);
        }
        return new IntervalSet(result);
    }

    public Option<IntervalSet> meet(IntervalSet other) {
        return this.createCartesianOpt(other, new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return a.meet(b);
            }
        });
    }

    public boolean subsetOrEqual(IntervalSet other) {
        IntervalSet joined = this.join(other);
        return joined.isEqualTo(other);
    }

    @Override
    public Iterator<Interval> iterator() {
        return this.intervals.iterator();
    }

    public Iterator<BigInt> iteratorInt() {
        return new ConcatIterator<BigInt>(this.intervals);
    }

    public Iterator<BigInt> iteratorIntWithStride(BigInt stride) {
        return new StridedIterator(this, stride);
    }

    public Bound low() {
        Interval lowestInterval = this.intervals.getFirst();
        return lowestInterval.low();
    }

    public Bound high() {
        Interval highestInterval = this.intervals.getLast();
        return highestInterval.high();
    }

    public boolean contains(BigInt value) {
        for (Interval interval : this.intervals) {
            if (!interval.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean isEqualTo(IntervalSet other) {
        Iterator<Interval> otherIt = other.iterator();
        Iterator<Interval> thisIt = this.iterator();
        while (otherIt.hasNext() && thisIt.hasNext()) {
            Interval thisInterval = thisIt.next();
            Interval otherInterval = otherIt.next();
            if (otherInterval.isEqualTo(thisInterval)) continue;
            return false;
        }
        return !otherIt.hasNext() && !thisIt.hasNext();
    }

    public boolean isConstant() {
        if (this.intervals.size() == 1) {
            return this.intervals.getFirst().isConstant();
        }
        return false;
    }

    public boolean isFinite() {
        return this.low().isFinite() && this.high().isFinite();
    }

    public BigInt getConstantOrNull() {
        if (this.isConstant()) {
            return this.low().asInteger();
        }
        return null;
    }

    public Interval convexHull() {
        return Interval.of(this.low(), this.high());
    }

    List<Interval> getIntervals() {
        return new ArrayList<Interval>(this.intervals);
    }

    public IntervalSet add(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.some(a.add(b));
            }
        });
    }

    public IntervalSet add(BigInt scalar) {
        return this.createCartesian(scalar, new Fn2<Interval, BigInt, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, BigInt scalar) {
                return Option.some(a.add(scalar));
            }
        });
    }

    public IntervalSet sub(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.some(a.sub(b));
            }
        });
    }

    public IntervalSet sub(BigInt scalar) {
        return this.createCartesian(scalar, new Fn2<Interval, BigInt, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, BigInt scalar) {
                return Option.some(a.sub(scalar));
            }
        });
    }

    public IntervalSet mul(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.some(a.mul(b));
            }
        });
    }

    public IntervalSet mul(BigInt right) {
        return this.createCartesian(right, new Fn2<Interval, BigInt, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, BigInt b) {
                return Option.some(a.mul(b));
            }
        });
    }

    public IntervalSet divRoundInvards(BigInt right) {
        return this.createCartesian(right, new Fn2<Interval, BigInt, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, BigInt b) {
                return Option.some(a.divRoundInvards(b));
            }
        });
    }

    public IntervalSet divRoundZero(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.fromNullable(a.divRoundZero(b));
            }
        });
    }

    public IntervalSet shl(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.some(a.shl(b));
            }
        });
    }

    public IntervalSet shr(IntervalSet right) {
        return this.createCartesian((Object)right, (Fn2)new Fn2<Interval, Interval, Option<Interval>>(){

            @Override
            public Option<Interval> apply(Interval a, Interval b) {
                return Option.some(a.shr(b));
            }
        });
    }

    public IntervalSet negate() {
        return this.mul(MINUSONE);
    }

    public IntervalSet createCartesian(IntervalSet other, Fn2<Interval, Interval, Option<Interval>> fn) {
        Option<IntervalSet> result = this.createCartesianOpt(other, fn);
        return result.get();
    }

    public Option<IntervalSet> createCartesianOpt(IntervalSet other, Fn2<Interval, Interval, Option<Interval>> fn) {
        LinkedList<Interval> result = new LinkedList<Interval>();
        for (Interval thisInt : this.getIntervals()) {
            for (Interval otherInt : other.getIntervals()) {
                Option<Interval> resultOption = fn.apply(thisInt, otherInt);
                if (!resultOption.isSome()) continue;
                result.add(resultOption.get());
            }
        }
        if (result.isEmpty()) {
            return Option.none();
        }
        return Option.some(new IntervalSet(result));
    }

    public <T> IntervalSet createCartesian(T arg, Fn2<Interval, T, Option<Interval>> fn) {
        LinkedList<Interval> result = new LinkedList<Interval>();
        for (Interval thisInt : this.getIntervals()) {
            Option<Interval> resultOption = fn.apply(thisInt, arg);
            if (!resultOption.isSome()) continue;
            result.add(resultOption.get());
        }
        return new IntervalSet(result);
    }

    public boolean equals(Object o) {
        return o instanceof IntervalSet && this.isEqualTo((IntervalSet)o);
    }

    public int hashCode() {
        int hash = 5;
        for (Interval interval : this.intervals) {
            hash = 7 * hash + interval.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.intervals.size() > 1) {
            builder.append("{ ");
        }
        boolean first = true;
        for (Interval interval : this.intervals) {
            if (first) {
                builder.append(interval.toString());
                first = false;
                continue;
            }
            builder.append(", ").append(interval.toString());
        }
        if (this.intervals.size() > 1) {
            builder.append(" }");
        }
        return builder.toString();
    }

    private static class StridedIterator
    implements Iterator<BigInt> {
        private final Iterator<Interval> intervalIterator;
        private final BigInt stride;
        private Interval curInterval;
        private BigInt ptr;

        private StridedIterator(IntervalSet set, BigInt stride) {
            this.intervalIterator = set.iterator();
            this.stride = stride;
            this.curInterval = this.intervalIterator.next();
            this.ptr = this.curInterval.low().asInteger();
        }

        private StridedIterator(IntervalSet set) {
            this(set, Bound.ONE);
        }

        @Override
        public boolean hasNext() {
            boolean strideInCurrentInterval;
            boolean bl = strideInCurrentInterval = this.stride.isPositive() && !this.curInterval.high().asInteger().isLessThan(this.ptr);
            if (strideInCurrentInterval) {
                return true;
            }
            boolean result = false;
            while (this.intervalIterator.hasNext()) {
                this.curInterval = this.intervalIterator.next();
                if (this.curInterval.contains(this.ptr)) {
                    result = true;
                    break;
                }
                BigInt timesStride = this.curInterval.low().asInteger().sub(this.ptr).div(this.stride);
                this.ptr = this.ptr.add(this.stride.mul(timesStride.add(Bound.ONE)));
                if (!this.curInterval.contains(this.ptr)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public BigInt next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BigInt next = this.ptr;
            this.ptr = this.ptr.add(this.stride);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

