/*
 * Decompiled with CFR 0.152.
 */
package javalx.numeric;

import javalx.data.Option;
import javalx.fn.Fn2;
import javalx.numeric.BigInt;
import javalx.numeric.Bound;

public class Congruence {
    private final BigInt scale;
    private final BigInt offset;
    public static final Congruence ZERO = new Congruence(0L, 0L);
    public static final Congruence ONE = new Congruence(1L, 0L);
    public static final Fn2<Congruence, Congruence, Congruence> join = new Fn2<Congruence, Congruence, Congruence>(){

        @Override
        public Congruence apply(Congruence a, Congruence b) {
            return a.join(b);
        }
    };

    public Congruence(long scale, long offset) {
        this(BigInt.of(scale), BigInt.of(offset));
    }

    public Congruence(BigInt scale, BigInt offset) {
        assert (!scale.isNegative());
        if (!scale.isZero()) {
            if (offset.isNegative()) {
                if ((offset = offset.remainder(scale)).isNegative()) {
                    offset = offset.add(scale);
                }
            } else if (!offset.isLessThan(scale)) {
                offset = offset.remainder(scale);
            }
        }
        this.offset = offset;
        this.scale = scale;
    }

    public BigInt getOffset() {
        return this.offset;
    }

    public BigInt getScale() {
        return this.scale;
    }

    public boolean isCongruent(BigInt x) {
        if (this.scale.isZero()) {
            return x.isEqualTo(this.offset);
        }
        Congruence xCongruence = new Congruence(this.scale, x);
        return xCongruence.equals(this);
    }

    public int lowerZeroBits() {
        if (!this.offset.isZero()) {
            return 0;
        }
        BigInt x = Bound.TWO;
        while (x.isLessThan(this.scale)) {
            x = x.shl(1);
        }
        x = x.gcd(this.scale);
        return Long.numberOfTrailingZeros(x.longValue());
    }

    public Congruence join(Congruence other) {
        return new Congruence(this.offset.sub(other.offset).abs().gcd(this.scale.gcd(other.scale)), this.offset.min(other.offset));
    }

    public Option<Congruence> meet(Congruence other) {
        BigInt gcd;
        if (!new Congruence(this.scale.gcd(other.scale), other.offset).isCongruent(this.offset)) {
            return Option.none();
        }
        BigInt a2_a1 = other.offset.sub(this.offset);
        if (a2_a1.isNegative() && !other.scale.isZero()) {
            a2_a1 = a2_a1.remainder(other.scale).add(other.scale);
        }
        if ((gcd = this.scale.gcd(other.scale).gcd(a2_a1)).isZero()) {
            return Option.some(this);
        }
        Congruence meet = new Congruence(Congruence.lcm(this.scale, other.scale), this.offset.add(this.scale.mul(a2_a1.div(gcd)).mul(Congruence.modularInverse(this.scale.div(gcd), other.scale.div(gcd)))));
        return Option.some(meet);
    }

    private static BigInt lcm(BigInt x, BigInt y) {
        if (!x.gcd(y).isZero()) {
            return x.mul(y).div(x.gcd(y));
        }
        return Bound.ZERO;
    }

    private static BigInt modularInverse(BigInt a1, BigInt b1) {
        BigInt x = Bound.ZERO;
        BigInt lastx = Bound.ONE;
        BigInt y = Bound.ONE;
        BigInt lasty = Bound.ZERO;
        while (!b1.isZero()) {
            BigInt quotient = a1.div(b1);
            BigInt temp = b1;
            b1 = a1.remainder(b1);
            a1 = temp;
            temp = x;
            x = lastx.sub(x.mul(quotient));
            lastx = temp;
            temp = y;
            y = lasty.sub(y.mul(quotient));
            lasty = temp;
        }
        return lastx;
    }

    public boolean subsetOrEqual(Congruence other) {
        if (this.isConstantOnly() && other.isConstantOnly()) {
            return this.getOffset().isEqualTo(other.getOffset());
        }
        if (this.isConstantOnly() || other.isConstantOnly()) {
            return true;
        }
        return this.scale.gcd(this.offset.sub(other.offset).abs()).remainder(other.scale).isZero();
    }

    public boolean isConstantOnly() {
        return this.scale.isZero();
    }

    public Congruence add(Congruence other) {
        return new Congruence(this.scale.gcd(other.scale), this.offset.add(other.offset));
    }

    public Congruence mul(Congruence other) {
        if (this.isConstantOnly()) {
            return other.mul(this.getOffset());
        }
        if (other.isConstantOnly()) {
            return this.mul(other.getOffset());
        }
        return new Congruence(this.offset.mul(other.scale).gcd(this.scale.mul(other.offset)).gcd(this.scale.mul(other.scale)), this.offset.mul(other.offset));
    }

    public Congruence sub(BigInt c) {
        return new Congruence(this.scale, this.offset.sub(c));
    }

    public Congruence mul(BigInt c) {
        return new Congruence(this.scale.mul(c.abs()), this.offset.mul(c));
    }

    public Congruence div(BigInt c) {
        if (c.isEqualTo(Bound.ONE)) {
            return this;
        }
        assert (!this.scale.isZero()) : "Division of constant congruences ill defined.";
        BigInt divisor = c.abs();
        if (divisor.isGreaterThan(this.getScale())) {
            return ONE;
        }
        BigInt[] dividedScale = this.scale.divideAndRemainder(divisor);
        BigInt[] dividedOffset = this.offset.divideAndRemainder(divisor);
        if (dividedScale[1].isZero() && dividedOffset[1].isZero()) {
            return new Congruence(dividedScale[0], dividedOffset[0]);
        }
        return ONE;
    }

    public Congruence shr(BigInt c) {
        if (this.isConstantOnly()) {
            return new Congruence(Bound.ZERO, this.offset.shr(c));
        }
        return this.div(Bound.TWO.pow(c));
    }

    public Congruence shl(BigInt c) {
        return this.mul(Bound.TWO.pow(c));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
        result = 31 * result + (this.scale == null ? 0 : this.scale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Congruence)) {
            return false;
        }
        Congruence other = (Congruence)obj;
        if (this.offset == null ? other.offset != null : !this.offset.isEqualTo(other.offset)) {
            return false;
        }
        return !(this.scale == null ? other.scale != null : !this.scale.isEqualTo(other.scale));
    }

    public String toString() {
        String offsetString = this.offset.isZero() ? "" : (this.offset.isNegative() ? "" : "+") + this.offset.toString();
        return "*" + this.scale.toString() + offsetString;
    }
}

