/*
 * Decompiled with CFR 0.152.
 */
package javalx.exceptions;

public class UncheckedExceptionWrapper
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Throwable exception;

    public UncheckedExceptionWrapper(Throwable exception) {
        this.exception = exception;
        this.setStackTrace(exception.getStackTrace());
    }

    public Throwable getWrappedException() {
        return this.exception;
    }

    @Override
    public String toString() {
        String message = this.getLocalizedMessage();
        StringBuilder builder = new StringBuilder();
        if (message == null) {
            message = this.getWrappedException().toString();
        }
        builder.append(message);
        builder.append("\nWrapped in exception: ");
        builder.append(this.getClass().getName());
        return builder.toString();
    }
}

