/*
 * Decompiled with CFR 0.152.
 */
package javalx.data;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javalx.fn.Fn;

public abstract class Option<A>
implements Iterable<A> {
    public abstract <B> Option<B> fmap(Fn<A, B> var1);

    public abstract A get();

    public A getOrElse(A defaultValue) {
        if (this.isSome()) {
            return this.get();
        }
        return defaultValue;
    }

    public A getOrNull() {
        return this.getOrElse(null);
    }

    public boolean isSome() {
        return this instanceof Some;
    }

    public boolean isNone() {
        return this instanceof None;
    }

    public static <T> Option<T> none() {
        return None.instance;
    }

    public static <T> Option<T> some(T value) {
        assert (value != null) : "Tried to instantiate Some with null.";
        return new Some(value);
    }

    public static <T> Option<T> fromNullable(T value) {
        if (value == null) {
            return Option.none();
        }
        return Option.some(value);
    }

    @Override
    public Iterator<A> iterator() {
        return new OptionIterator(this);
    }

    private static class OptionIterator<A>
    implements Iterator<A> {
        private Option<A> option;

        private OptionIterator(Option<A> option) {
            this.option = option;
        }

        @Override
        public boolean hasNext() {
            return this.option.isSome();
        }

        @Override
        public A next() {
            A value = this.option.get();
            this.option = Option.none();
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not allowed for Option values");
        }
    }

    private static final class None<A>
    extends Option<A> {
        private static final None<?> instance = new None();

        private None() {
        }

        @Override
        public A get() {
            throw new NoSuchElementException("'None' does not contain any value");
        }

        @Override
        public <B> Option<B> fmap(Fn<A, B> f) {
            return None.none();
        }

        public boolean equals(Object obj) {
            return obj instanceof None;
        }

        public int hashCode() {
            return 3;
        }

        public String toString() {
            return "None{}";
        }
    }

    private static final class Some<A>
    extends Option<A> {
        final A value;

        private Some(A value) {
            this.value = value;
        }

        @Override
        public A get() {
            return this.value;
        }

        @Override
        public <B> Option<B> fmap(Fn<A, B> f) {
            return Some.some(f.apply(this.value));
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Some)) {
                return false;
            }
            Some other = (Some)obj;
            return this.value == other.value || this.value != null && this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "Some{" + this.value + '}';
        }
    }
}

