/*
 * Decompiled with CFR 0.152.
 */
package javalx.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ConcatIterator<T>
implements Iterator<T> {
    private final List<Iterator<T>> arr;
    private final Iterator<Iterator<T>> arrIterator;
    private Iterator<T> currIterator = null;

    public <TX extends Iterable<T>> ConcatIterator(Collection<TX> iterables) {
        this.arr = new ArrayList<Iterator<T>>(iterables.size());
        for (Iterable iterable : iterables) {
            this.arr.add(iterable.iterator());
        }
        this.arrIterator = this.arr.iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currIterator != null && this.currIterator.hasNext()) {
            return true;
        }
        while (this.arrIterator.hasNext()) {
            this.currIterator = this.arrIterator.next();
            if (!this.currIterator.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        if (this.currIterator != null && this.currIterator.hasNext()) {
            return this.currIterator.next();
        }
        while (this.arrIterator.hasNext()) {
            this.currIterator = this.arrIterator.next();
            if (!this.currIterator.hasNext()) continue;
            return this.currIterator.next();
        }
        return null;
    }

    @Override
    public void remove() {
        if (this.currIterator != null && this.currIterator.hasNext()) {
            this.currIterator.remove();
        }
        while (this.arrIterator.hasNext()) {
            this.currIterator = this.arrIterator.next();
            if (!this.currIterator.hasNext()) continue;
            this.currIterator.remove();
            return;
        }
    }
}

